<?php
// $Id: error.php 2237 2017-05-20 20:42:38Z tom.houdayer $

if (isset($_GET['error'])) {
        # Choice of language
        $Language = 'en';
        if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
                $Langue = explode(',', $_SERVER['HTTP_ACCEPT_LANGUAGE']);
                $Language = strtolower(substr(chop($Langue[0]), 0, 2));
        }
        if ($Language === 'fr') {
                switch ($_GET['error']) {
                        case 400:
                                $l_error = "Erreur 400";
                                $l_explanation = "La requête HTTP n'a pas pu être comprise par le serveur en raison d'une syntaxe erronée.<br>
                                                  Le problème peut provenir d'un navigateur web trop récent ou d'un serveur HTTP trop ancien.";
                                break;
                        case 401:
                                $l_error = "Erreur 401";
                                $l_explanation = "La requête nécessite une identification de l'utilisateur.<br>
                                                  Concrètement, cela signifie que tout ou partie du serveur contacté est protégé par un mot de passe, qu'il faut indiquer au serveur pour pouvoir accéder à son contenu.";
                                break;
                        case 403:
                                $l_error = "Erreur 403";
                                $l_explanation = "Le serveur HTTP a compris la requête, mais refuse de la traiter.<br>
                                                  Ce code est généralement utilisé lorsqu'un serveur ne souhaite pas indiquer pourquoi la requête a été rejetée, ou lorsque aucune autre réponse ne correspond (par exemple le serveur est un Intranet et seules les machines du réseau local sont autorisées à se connecter au serveur).";
                                break;
                        case 404:
                                $l_error = "Erreur 404";
                                $l_explanation = "Le serveur n'a rien trouvé qui corresponde à l'adresse (URI) demandée ( non trouvé ).<br>
                                                  Cela signifie que l'URL que vous avez tapée ou cliquée est mauvaise ou obsolète et ne correspond à aucun document existant sur le serveur (vous pouvez essayez de supprimer progressivement les composants de l'URL en partant de la fin pour éventuellement retrouver un chemin d'accès existant).";
                                break;
                        case 405:
                                $l_error = "Erreur 405";
                                $l_explanation = "Ce code indique que la méthode utilisée par le client n'est pas supportée pour cet URI.";
                                break;
                        case 408:
                                $l_error = "Erreur 408";
                                $l_explanation = "Le client n'a pas présenté une requête complète pendant le délai maximal qui lui était imparti, et le serveur a abandonné la connexion.";
                                break;
                        case 410:
                                $l_error = "Erreur 410";
                                $l_explanation = "L'adresse (URI) demandée n'existe plus et a été définitivement supprimée du serveur.";
                                break;
                        case 411:
                                $lerror = "Erreur 411";
                                $l_explanation = "Le serveur a besoin de connaître la taille de cette requête pour pouvoir y répondre.";
                                break;
                        case 413:
                                $l_error = "Erreur 413";
                                $l_explanation = "Le serveur ne peut traiter la requête car la taille de son contenu est trop importante.";
                                break;
                        case 414:
                                $l_error = "Erreur 414";
                                $l_explanation = "Le serveur ne peut traiter la requête car la taille de l'objet (URI) a retourner est trop importante.";
                                break;
                        case 415:
                                $l_error = "Erreur 415";
                                $l_explanation = "Le serveur ne peut traiter la requête car son contenu est écrit dans un format non supporté.";
                                break;
                        case 500:
                                $l_error = "Erreur 500";
                                $l_explanation = "Le serveur HTTP a rencontré une condition inattendue qui l'a empêché de traiter la requête.<br>
                                                  Cette erreur peut par exemple être le résultat d'une mauvaise configuration du serveur, ou d'une ressource épuisée ou refusée au serveur sur la machine hôte.";
                                break;
                        case 501:
                                $l_error = "Erreur 501";
                                $l_explanation = "Le serveur HTTP ne supporte pas la fonctionnalité nécessaire pour traiter la requête.<br>
                                                  C'est la réponse émise lorsque le serveur ne reconnaît pas la méthode indiquée dans la requête et n'est capable de la mettre en oeuvre pour aucune ressource (soit le navigateur web est trop récent, soit le serveur HTTP est trop ancien).";
                                break;
                        case 502:
                                $l_error = "Erreur 502";
                                $l_explanation = "Le serveur intermédiaire a fourni une réponse invalide.<br>
                                                  Le serveur HTTP a agi en tant qu'intermédiaire (passerelle ou proxy) avec un autre serveur, et a reçu de ce dernier une réponse invalide en essayant de traiter la requête.";
                                break;
                        case 503:
                                $l_error = "Erreur 503";
                                $l_explanation = "Le serveur HTTP est actuellement incapable de traiter la requête en raison d'une surcharge temporaire ou d'une opération de maintenance.<br> Cela sous-entend l'existence d'une condition temporaire qui sera levée après un certain délai.";
                                break;
                        case 506:
                                $l_error = "Erreur 506";
                                $l_explanation = "Erreur de négociation transparent content negociation.";
                                break;
                        default:
                                $l_error = "Non reconnu";
                                $l_explanation = "Erreur non reconnue.";
                                break;
                }
        } else if ($Language === 'es') {
                switch ($_GET['error']) {
                        case 400:
                                $l_error = "Error 400";
                                $l_explanation = "El servidor no pudo entender la solicitud HTTP debido a una sintaxis con formato incorrecto.<br>El navegador web puede ser demasiado reciente o el servidor HTTP puede ser demasiado antiguo.";
                                break;
                        case 401:
                                $l_error = "Error 401";
                                $l_explanation = "La solicitud requiere autenticación de usuario.<br>Esto significa que todo o parte del servidor solicitado está protegido por una contraseña que se debe proporcionar al servidor para permitir el acceso a su contenido.";
                                break;
                        case 403:
                                $l_error = "Error 403";
                                $l_explanation = "El servidor HTTP entendió la solicitud, pero se niega a cumplirla.<br>Este código de estado se usa comúnmente cuando el servidor no desea revelar exactamente por qué se rechazó la solicitud o cuando no se aplica ninguna otra respuesta (por ejemplo, el servidor es una Intranet y solo las máquinas LAN están autorizadas para conectarse).";
                                break;
                        case 404:
                                $l_error = "Error 404";
                                $l_explanation = "El servidor no ha encontrado nada que coincida con la dirección solicitada (URI) (no encontrado).<br>Esto significa que la URL que escribió o cliqueó es incorrecta u obsoleta y no coincide con ningún documento existente en el servidor (puede intentar eliminar gradualmente los componentes de URL de derecha a izquierda para recuperar eventualmente una ruta existente).";
                                break;
                        case 405:
                                $l_error = "Error 405";
                                $l_explanation = "Este código se proporciona con el Allow header e indica que el método utilizado por el cliente no es compatible con este URI.";
                                break;
                        case 408:
                                $l_error = "Error 408";
                                $l_explanation = "Este código de respuesta significa que el cliente no produjo una solicitud completa dentro de un tiempo predeterminado (generalmente especificado en la configuración del servidor), y el servidor está desconectando la conexión de red.";
                                break;
                        case 410:
                                $l_error = "Error 410";
                                $l_explanation = "Este código indica que el URI solicitado ya no existe y se ha eliminado permanentemente del servidor.";
                                break;
                        case 411:
                                $lerror = "Error 411";
                                $l_explanation = "El servidor no aceptará la solicitud sin un encabezado Content-Length proporcionado en la solicitud.";
                                break;
                        case 413:
                                $l_error = "Error 413";
                                $l_explanation = "El servidor no procesará la solicitud porque su cuerpo de entidad es demasiado grande.";
                                break;
                        case 414:
                                $l_error = "Error 414";
                                $l_explanation = "El servidor no procesará la solicitud porque su URI de solicitud es demasiado grande.";
                                break;
                        case 415:
                                $l_error = "Error 415";
                                $l_explanation = "El servidor no procesará la solicitud porque su entity-body está en un formato no compatible.";
                                break;
                        case 500:
                                $l_error = "Error 500";
                                $l_explanation = "El servidor HTTP encontró una condición inesperada que le impidió cumplir con la solicitud.<br>Por ejemplo, este error puede ser causado por una configuración incorrecta del servidor o un recurso agotado o denegado al servidor en la máquina host.";
                                break;
                        case 501:
                                $l_error = "Error 501";
                                $l_explanation = "El servidor HTTP no admite la funcionalidad requerida para cumplir con la solicitud.<br>Esta es la respuesta adecuada cuando el servidor no reconoce el método de solicitud y no es capaz de admitirlo para ningún recurso (el navegador web es demasiado reciente o el servidor HTTP es demasiado antiguo).";
                                break;
                        case 502:
                                $l_error = "Error 502";
                                $l_explanation = "El servidor de puerta de enlace devolvió una respuesta no válida.<br>El servidor HTTP, mientras actuaba como puerta de enlace o proxy, recibió una respuesta no válida del servidor ascendente al que accedió al intentar cumplir con la solicitud.";
                                break;
                        case 503:
                                $l_error = "Error 503";
                                $l_explanation = "El servidor HTTP actualmente no puede manejar la solicitud debido a una sobrecarga o mantenimiento temporal del servidor.<br>Ésto implica que esta es una condición temporal que se aliviará después de algún retraso.";
                                break;
                        case 506:
                                $l_error = "Error 506";
                                $l_explanation = "La negociación de contenido transparente para la solicitud da como resultado una referencia circular.";
                                break;
                        default:
                                $l_error = "No reconocido";
                                $l_explanation = "Error desconocido.";
				break;
		}
        } else if ($Language === 'de') {
                switch ($_GET['error']) {
                        case 400:
                                $l_error = "Fehler 400";
                                $l_explanation = "Die Anfrage konnte aufgrund einer fehlerhaften Syntax vom Server nicht verarbeitet werden.<br>Wahrscheinlich handelt es sich entweder um einen zu neuen Browser oder einen zu alten Server.";
                                break;
                        case 401:
                                $l_error = "Fehler 401";
                                $l_explanation = "Die Anfrage benötigt eine Authentifizierung.<br>Dies bedeutet, dass der Server oder Teile des Servers passwortgeschützt sind.";
                                break;
                        case 403:
                                $l_error = "Fehler 403";
                                $l_explanation = "Der HTTP-Server hat die Anfrage verstanden, möchte sie jedoch nicht beantworten.<br>Dieser Statuscode wird meistens benutzt wenn der Server nicht genau sagen möchte, wieso die Anfrage nicht verarbeitet wurde, oder wenn keine andere Antwort angemessen ist (zum Beispiel wenn der Server einem Intranet angehört und nur LAN Maschinen sich verbinden können).";
                                break;
                        case 404:
                                $l_error = "Fehler 404";
                                $l_explanation = "Der Server konnte die vom Client unter dieser URI angeforderte Ressource nicht finden.<br>Dies bedeutet dass die URL die Sie angeklickt haben entweder falsch oder veraltet ist und mit keinem existierenden Dokument auf dem Server verbunden ist (Sie können versuchen Stück für Stück die URL-Komponenten von rechts zu entfernen um zum nächsten existierenden Pfad zu gelangen).";
                                break;
                        case 405:
                                $l_error = "Fehler 405";
                                $l_explanation = "Dieser Statuscode hängt mit dem Allow-Header zusammen und bedeutet dass die verwendete Methode für diese URI nicht unterstützt ist.";
                                break;
                        case 408:
                                $l_error = "Fehler 408";
                                $l_explanation = "Die Anfrage wurde vom Client nicht in der vom Server vorgegebenen Zeit beendet und wurde vom Server beendet.";
                                break;
                        case 410:
                                $l_error = "Fehler 410";
                                $l_explanation = "Die Ressource unter der angegebenen URI existiert nicht mehr. Leider kennt der Server keine Weiterleitungsadresse.";
                                break;
                        case 411:
                                $lerror = "Fehler 411";
                                $l_explanation = "Der Server akzeptiert die Anfrage nicht, wenn in der Anfrage kein Content-Length-Header angegeben ist.";
                                break;
                        case 413:
                                $l_error = "Fehler 413";
                                $l_explanation = "Der Inhalt der Anfrage ist zu groß, die Anfrage wird abgelehnt.";
                                break;
                        case 414:
                                $l_error = "Fehler 414";
                                $l_explanation = "Der Server wird die Anfrage nicht beantworten, da die Anfrage-URI zu lang ist.";
                                break;
                        case 415:
                                $l_error = "Fehler 415";
                                $l_explanation = "Die Anfrage wird nicht beantwortet, da der Inhalt ein nicht unterstütztes Format beinhaltet.";
                                break;
                        case 500:
                                $l_error = "Fehler 500";
                                $l_explanation = "Der Server hat einen internen Fehler entdeckt und kann deshalb die Anfrage nicht bearbeiten.<br>Diese Fehler kann beispielsweise durch eine Fehlkonfiguration des Servers entstehen.";
                                break;
                        case 501:
                                $l_error = "Fehler 501";
                                $l_explanation = "Der Server verfügt nicht über die nötige Funktionalität, um die Anfrage zu verarbeiten.<br>Dies bedeutet, dass der Server die in der Anfrage verwendete HTTP-Methode nicht unterstützt (entweder ist der Browser zu neu oder der Server zu alt).";
                                break;
                        case 502:
                                $l_error = "Fehler 502";
                                $l_explanation = "Das Gateway hat eine falsche Antwort geliefert.<br>Der Server kann die Anfrage nicht ausführen, weil im weiteren Verlauf ein Fehler aufgetreten ist.";
                                break;
                        case 503:
                                $l_error = "Fehler 503";
                                $l_explanation = "Der Dienst ist derzeit nicht verfügbar. Dies kann aufgrund hohen Datenaufkommens oder wegen Wartungsarbeiten passieren.<br>Dies ist ein temporäres Problem und wird sich nach einiger Zeit lösen.";
                                break;
                        case 506:
                                $l_error = "Fehler 506";
                                $l_explanation = "Die Inhaltsvereinbarung der Anfrage ergibt einen Zirkelbezug.";
                                break;
                        default:
                                $l_error = "Fehler";
                                $l_explanation = "Unbekannter Fehler.";
				break;
		}
        } else {
                switch ($_GET['error']){
                        case 400:
                                $l_error = "Error 400";
                                $l_explanation = "The HTTP request could not be understood by the server due to malformed syntax.<br>
                                                  The web browser may be too recent, or the HTTP server may be too old.";
                                break;
                        case 401:
                                $l_error = "Error 401";
                                $l_explanation = "The request requires user authentication.<br>
                                                  This means that all or a part of the requested server is protected by a password that should be given to the server to allow access to its contents.";
                                break;
                        case 403:
                                $l_error = "Error 403";
                                $l_explanation = "The HTTP server understood the request, but is refusing to fulfill it.<br>
                                                  This status code is commonly used when the server does not wish to reveal exactly why the request has been refused, or when no other response is applicable (for example the server is an Intranet and only the LAN machines are authorized to connect).";
                                break;
                        case 404:
                                $l_error = "Error 404";
                                $l_explanation = "The server has not found anything matching the requested address (URI) ( not found ).<br>
                                                  This means the URL you have typed or cliked on is wrong or obsolete and does not match any document existing on the server (you may try to gradualy remove the URL components from the right to the left to eventualy retrieve an existing path).";
                                break;
                        case 405:
                                $l_error = "Error 405";
                                $l_explanation = "This code is given with the Allow header and indicates that the method used by the client is not supported for this URI.";
                                break;
                        case 408:
                                $l_error = "Error 408";
                                $l_explanation = "This response code means the client did not produce a full request within some predetermined time (usually specified in the server's configuration), and the server is disconnecting the network connection.";
                                break;
                        case 410:
                                $l_error = "Error 410";
                                $l_explanation = "This code indicates that the requested URI no longer exists and has been permanently removed from the server.";
                                break;
                        case 411:
                                $lerror = "Error 411";
                                $l_explanation = "The server will not accept the request without a Content-Length header supplied in the request.";
                                break;
                        case 413:
                                $l_error = "Error 413";
                                $l_explanation = "The server will not process the request because its entity body is too large.";
                                break;
                        case 414:
                                $l_error = "Error 414";
                                $l_explanation = "The server will not process the request because its request URI is too large.";
                                break;
                        case 415:
                                $l_error = "Error 415";
                                $l_explanation = "The server will not process the request because its entity body is in an unsupported format.";
                                break;
                        case 500:
                                $l_error = "Error 500";
                                $l_explanation = "The HTTP server encountered an unexpected condition which prevented it from fulfilling the request.<br>
                                                  For example this error can be caused by a serveur misconfiguration, or a resource exhausted or denied to the server on the host machine.";
                                break;
                        case 501:
                                $l_error = "Error 501";
                                $l_explanation = "The HTTP server does not support the functionality required to fulfill the request.<br>
                                                  This is the appropriate response when the server does not recognize the request method and is not capable of supporting it for any resource (either the web browser is too recent, or the HTTP server is too old).";
                                break;
                        case 502:
                                $l_error = "Error 502";
                                $l_explanation = "The gateway server returned an invalid response.<br>
                                                  The HTTP server, while acting as a gateway or proxy, received an invalid response from the upstream server it accessed in attempting to fulfill the request.";
                                break;
                        case 503:
                                $l_error = "Error 503";
                                $l_explanation = "The HTTP server is currently unable to handle the request due to a temporary overloading or maintenance of the server.<br>
                                                  The implication is that this is a temporary condition which will be alleviated after some delay.";
                                break;
                        case 506:
                                $l_error = "Error 506";
                                $l_explanation = "Transparent content negotiation for the request results in a circular reference.";
                                break;
                        default:
                                $l_error = "Unknown";
                                $l_explanation = "Unknown error.";
                                break;
                }
        }
}
// Cleaning the cache
header('Expires: Tue, 01 Jan 2000 00:00:00 GMT');
header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Cache-Control: post-check=0, pre-check=0', false);
header('Pragma: no-cache');
?>
<!DOCTYPE html>
<html>
        <head>
                <meta charset="UTF-8">
                <title>ALCASAR - <?= $l_error; ?></title>
                <link rel="stylesheet" type="text/css" href="/css/error.css">
        </head>
        <body>
                <div id="cadre_titre" class="titre_refus">
                        <p id="acces_controle" class="titre_refus"><?= $l_error ?></p>
                        <div id="boite_logo"><img src="/images/organisme.png"></div>
                </div>

                <div id="contenu_error">
                        <?= $l_explanation ?>
                </div>
        </body>
</html>
