<?php
/**
 * Translations of users tickets
 *
 * @copyright Copyright (C) ALCASAR (http://www.alcasar.net)
 * @license   GPL-3.0
 * @version   $Id: langues_imp.php 2851 2020-07-16 21:54:46Z rexy $
 */

// Read conf file
$CONF_FILE = '/usr/local/etc/alcasar.conf';
if (!file_exists($CONF_FILE)) {
	exit("Requested file $CONF_FILE isn't present");
}
if (!is_readable($CONF_FILE)) {
	exit("Can't read the file $CONF_FILE");
}
$ouvre = fopen($CONF_FILE, 'r');
if ($ouvre) {
	while (!feof($ouvre)) {
		$buffer = fgets($ouvre, 4096);
		if (strpos($buffer, '=') !== false) {
			$tmp = explode('=', $buffer, 2);
			$conf[trim($tmp[0])] = trim($tmp[1]);
		}
	}
	fclose($ouvre);
}

// Translations
switch ($langue_imp) {
	case 'fr':                     // French
		$l_title_imp               = "TICKET D'ACCÈS";
		$l_login_imp               = "Utilisateur :";
		$l_password_imp            = "Mot de passe :";
		$l_max_all_session_imp     = "Durée maximale :";
		$l_session_timeout_imp     = "Durée d'une session :";
		$l_max_daily_session_imp   = "Durée quotidienne :";
		$l_max_monthly_session_imp = "Durée mensuelle :";
		$l_expiration_imp          = "Date d'expiration :";
		$l_unlimited               = "Illimitée";
		$l_without                 = "Aucune";
		$l_duplicate               = "Duplicata";
		$l_explain                 = "Entrer 'http://".trim($conf["HOSTNAME"]).".".trim($conf["DOMAIN"])."' dans votre navigateur pour gérer votre compte (mot de passe, certificat, etc.).
		                              Entrer 'http://logout' dans votre navigateur pour vous déconnecter.";
		$l_footer_imp              = "Généré par ALCASAR";
		break;

	case 'de':                     // German
		$l_title_imp               = "ZUGANG TICKET";
		$l_login_imp               = "Login :";
		$l_password_imp            = "Passwort :";
		$l_max_all_session_imp     = "Maximale Dauer :";
		$l_session_timeout_imp     = "Dauer der Sitzung :";
		$l_max_daily_session_imp   = "Stunden t&auml;glich :";
		$l_max_monthly_session_imp = "monatlich Dauer :";
		$l_expiration_imp          = "Verfallsdatum :";
		$l_unlimited               = "Unbegrenzt";
		$l_without                 = "Ohne";
		$l_duplicate               = "Duplikat";
		$l_explain                 = "Geben Sie 'http://".trim($conf["HOSTNAME"]).".".trim($conf["DOMAIN"])."' in Ihrem Browser, um Ihr Konto zu verwalten (kennwort, zertifikat, etc.).
		                              Geben Sie 'http://logout' in Ihrem Browser zu trennen.";
		$l_footer_imp              = "Präsentiert von ALCASAR";
		break;

	case 'nl':                     // Dutch
		$l_title_imp               = "TOERANG TICKET";
		$l_login_imp               = "Gebruikers :";
		$l_password_imp            = "Wachtwoord :";
		$l_max_all_session_imp     = "Maximale duur :";
		$l_session_timeout_imp     = "Sessieduur :";
		$l_max_daily_session_imp   = "Dagelijkse uren :";
		$l_max_monthly_session_imp = "Maandelijkse duur :";
		$l_expiration_imp          = "Vervaldatum :";
		$l_unlimited               = "Onbeperkte";
		$l_without                 = "Ohne";
		$l_duplicate               = "Duplicaat";
		$l_explain                 = "Voer 'http://".trim($conf["HOSTNAME"]).".".trim($conf["DOMAIN"])."' in uw browser om uw account te beheren (wachtwoord, certificaat, etc.).
		                              Voer 'http://logout' in uw browser de verbinding te verbreken.";
		$l_footer_imp              = "Powered by ALCASAR";
		break;

	case 'es':                     // Spanish
		$l_title_imp               = "TURISTICA ACCESO";
		$l_login_imp               = "Usuario :";
		$l_password_imp            = "Contraseña :";
		$l_max_all_session_imp     = "duración máxima :";
		$l_session_timeout_imp     = "Duración de Sesión :";
		$l_max_daily_session_imp   = "Duración diario :";
		$l_max_monthly_session_imp = "Duraci&oacute;n mensual :";
		$l_expiration_imp          = "Fecha de caducidad :";
		$l_unlimited               = "Ilimitado";
		$l_without                 = "Sin";
		$l_duplicate               = "Duplicado";
		$l_explain                 = "Escribe 'http://".trim($conf["HOSTNAME"]).".".trim($conf["DOMAIN"])."' de su navegador para administrar su cuenta (contraseña, certificado, etc.).
		                              Escribe 'http://logout' de su navegador para desconectar.";
		$l_footer_imp              = "Desarrollado por ALCASAR";
		break;

	case 'it':                     // Italian
		$l_title_imp               = "TICKET D'ACCESSO";
		$l_login_imp               = "Utenti :";
		$l_password_imp            = "Password :";
		$l_max_all_session_imp     = "Durata massima :";
		$l_session_timeout_imp     = "Durata della sessione :";
		$l_max_daily_session_imp   = "Durata quotidiano :";
		$l_max_monthly_session_imp = "Durata mensile :";
		$l_expiration_imp          = "Data di scadenza :";
		$l_unlimited               = "Illimitato";
		$l_without                 = "Senza";
		$l_duplicate               = "Duplicato";
		$l_explain                 = "Inserisci 'http://".trim($conf["HOSTNAME"]).".".trim($conf["DOMAIN"])."' nel tuo browser per gestire il tuo account (password, certificato, ecc).
		                              Inserisci 'http://logout' nel tuo browser per disconnettersi.";
		$l_footer_imp              = "Powered by ALCASAR";
		break;

	case 'pt':                     // Portuguese
		$l_title_imp               = "BILHETE DE ACESSO";
		$l_login_imp               = "Usuário :";
		$l_password_imp            = "Senha :";
		$l_max_all_session_imp     = "duração máxima :";
		$l_session_timeout_imp     = "Duração de uma sessão :";
		$l_max_daily_session_imp   = "Duração diária :";
		$l_max_monthly_session_imp = "Duração Mensal :";
		$l_expiration_imp          = "Data de validade :";
		$l_unlimited               = "Ilimitado";
		$l_without                 = "Sem";
		$l_duplicate               = "Duplicado";
		$l_explain                 = "Digite 'http://".trim($conf["HOSTNAME"]).".".trim($conf["DOMAIN"])."' no seu navegador para gerenciar sua conta (senha, certidão, etc).
		                              Digite 'http://logout' no seu navegador para desligar.";
		$l_footer_imp              = "Desenvolvido por ALCASAR";
		break;

	case 'ar':                     // Arabic
		$l_title_imp               = "وصول التذاكر";
		$l_login_imp               = "مستخدم:";
		$l_password_imp            = "كلمه السر:";
		$l_max_all_session_imp     = "المدة القصوى";
		$l_session_timeout_imp     = "مهلة جلسة:";
		$l_max_daily_session_imp   = "جلسة اليومية القصوى:";
		$l_max_monthly_session_imp = "جلسة الشهرية القصوى:";
		$l_expiration_imp          = "تاريخ إنتهاء الصلاحية:";
		$l_unlimited               = "غير محدود:";
		$l_without                 = "بدون";
		$l_duplicate               = "مكرر";
		$l_explain                 = " في المتصفح الخاص بك لخروج.'http://logout' في المستعرض الخاص بك لإدارة حسابك (كلمه السر, شهادة, ...). يكتب 'http://".trim($conf["HOSTNAME"]).".".trim($conf["DOMAIN"])."' يكتب";
		$l_footer_imp              = "مشغل بواسطة ALCASAR";
		break;

	default:                       // English
		$l_title_imp               = "ACCESS TICKET";
		$l_login_imp               = "Login :";
		$l_password_imp            = "Password :";
		$l_max_all_session_imp     = "Maximal duration :";
		$l_session_timeout_imp     = "Session timeout :";
		$l_max_daily_session_imp   = "Max daily session :";
		$l_max_monthly_session_imp = "Max monthly session :";
		$l_expiration_imp          = "Expiration date :";
		$l_unlimited               = "Unlimited";
		$l_without                 = "Without";
		$l_duplicate               = "Duplicate";
		$l_explain                 = "Enter 'http://".trim($conf["HOSTNAME"]).".".trim($conf["DOMAIN"])."' in your browser to manage your account (password, certificate, etc.).
		                              Enter 'http://logout' in your browser to disconnect.";
		$l_footer_imp              = "Powered by ALCASAR";
		break;
}
