<?php
/**
 * Tickets template for TicketsGenerator
 *
 * @author    Tom Houdayer & Rexy
 * @copyright Copyright (C) ALCASAR (http://www.alcasar.net)
 * @license   GPL-3.0
 * @version   $Id: tickets.template.php 2851 2020-07-16 21:54:46Z rexy $
 */

$langue_imp = $language;
require __DIR__ . '/../langues_imp.php';

$img_logoAlcasar      = __DIR__ . '/../../../../images/logo-alcasar.png';
$img_logoOrganization = __DIR__ . '/../../../../images/organisme.png';
?>
<!doctype html>
<html>
<head>
	<meta charset="utf-8">
	<style>
	@font-face {
		font-family: 'DejaVuSerif';
		src: url("/usr/share/fonts/TTF/dejavu/DejaVuSerif.ttf") format('truetype');
	}	
		body {
			margin: 0;
		}
		.ticket {
			margin: 14px 0;
			width: 50%;
			display: inline-block;
			font-family: 'DejaVuSerif';
			font-size: 8px;
			line-height: 16px;
		}
		.ticket-header {
			min-height:  30px;
			line-height: 30px;
			font-size: 10px;
			text-align: center;
		}
		.ticket-header > .ticket-title {
			color: red;
			font-weight: bold;
		}
		.ticket-box {
			position: relative;
			border: 1px solid black;
			border-radius: 10px;
			width: 220px;
			margin: 0 auto;
		}
		.ticket-box > .logo {
			position: absolute;
			display: inline-block;
			width:  60px;
			height: 60px;
			text-align: center;
		}
		.ticket-box > .logo img {
			max-width:  100%;
			max-height: 100%;
		}
		.ticket-box > .logo-alcasar {
			top:  -30px;
			left: -30px;
		}
		.ticket-box > .logo-organization {
			top:   -30px;
			right: -30px;
		}
		.ticket-body {
			position: relative;
			z-index: 10;
			padding: 5px;
		}
		.ticket-body > div > span {
			display: inline-block;
		}
		.ticket-body > div.spacer {
			height: 10px;
		}
		.ticket-body > div > span.key {
			width: 52%;
			text-align: right;
		}
		.ticket-body > div > span.value {
			width: 48%;
			font-weight: bold;
		}
		.ticket-footer > .infos {
			font-size: 7px;
			height: 52px;
		}
		.center {
			text-align: center;
		}
	</style>
</head>
<body>
	<?php foreach ($users as $user):
	  ?><div class="ticket">
			<div class="ticket-header">
				<span class="ticket-title"><?= $l_title_imp ?></span>
			</div>
			<div class="ticket-box">
				<div class="logo logo-alcasar"><img src="<?= $img_logoAlcasar ?>" alt=""></div>
				<div class="logo logo-organization"><img src="<?= $img_logoOrganization ?>" alt=""></div>
				<div class="ticket-body">
					<div class="spacer"></div>
					<div><span class="key"><?= $l_login_imp ?>&nbsp;</span><span class="value"><?= $user->username ?></span></div>
					<div><span class="key"><?= $l_password_imp ?>&nbsp;</span><span class="value"><?= $user->password ?></span></div>
					<div class="spacer"></div>
					<div><span class="key"><?= $l_max_all_session_imp ?>&nbsp;</span><span class="value"><?= $user->maxAllSession ?></span></div>
					<div><span class="key"><?= $l_session_timeout_imp ?>&nbsp;</span><span class="value"><?= $user->sessionTimeout ?></span></div>
					<div><span class="key"><?= $l_max_daily_session_imp ?>&nbsp;</span><span class="value"><?= $user->maxDailySession ?></span></div>
					<div><span class="key"><?= $l_expiration_imp ?>&nbsp;</span><span class="value"><?= $user->expiration ?></span></div>
					<div class="spacer"></div>
				</div>
			</div>
			<div class="ticket-footer">
				<?php if ($user->isDuplicate): ?>
					<div class="infos center">
						<p><?= $l_duplicate ?></p>
					</div>
				<?php else: ?>
					<div class="infos">
						<p><?= nl2br($l_explain, false) ?></p>
					</div>
				<?php endif; ?>
				<div class="credits center"><?= $l_footer_imp ?></div>
			</div>
		</div><?php
	endforeach; ?>
</body>
</html>
