<?php
/**
 * Print tickets of the new user
 *
 * @author    Tom Houdayer
 * @copyright Copyright (C) ALCASAR (http://www.alcasar.net)
 * @license   GPL-3.0
 * @version   $Id: ticket_user.php 2698 2019-02-05 10:25:12Z tom.houdayer $
 */

require_once __DIR__ . '/../lib/alcasar/TicketsGenerator.php';
$langue_imp = ((isset($_POST['langue_imp'])) ? $_POST['langue_imp'] : 'en');
require_once __DIR__ . '/../lib/langues_imp.php';
require_once '/etc/freeradius-web/config.php';
require_once __DIR__ . '/../lib/sql/drivers/mysql/functions.php';

// Get datas from form
if ((!isset($_POST['username'])) || (!isset($_POST['password']))) {
	exit();
}
$username = $_POST['username'];
$password = $_POST['password'];

// Get user attributes
$userAttr = [];
$link = da_sql_pconnect($config);
if ($link) {
	$user_uid = da_sql_escape_string($link, $username);
	$sql = "SELECT attribute, value FROM (( SELECT attribute, value FROM radcheck WHERE (attribute IN ('Max-All-Session', 'Max-Daily-Session', 'Expiration')) AND username = '$user_uid') UNION ( SELECT attribute, value FROM radgroupcheck gr LEFT JOIN radusergroup ug ON gr.groupname = ug.groupname WHERE (attribute IN ('Max-All-Session', 'Max-Daily-Session', 'Expiration')) AND username = '$user_uid' ORDER BY ug.priority) UNION ( SELECT attribute, value FROM radgroupcheck WHERE groupname = 'ldap' AND (attribute IN ('Max-All-Session', 'Max-Daily-Session', 'Expiration'))) UNION ( SELECT attribute, value FROM radreply WHERE (attribute IN ('Session-Timeout')) AND username = '$user_uid') UNION ( SELECT attribute, value FROM radgroupreply gr LEFT JOIN radusergroup ug ON gr.groupname = ug.groupname WHERE (attribute IN ('Session-Timeout')) AND username = '$user_uid' ORDER BY ug.priority) UNION ( SELECT attribute, value FROM radgroupreply WHERE groupname = 'ldap' AND (attribute IN ('Session-Timeout')))) attrs GROUP BY attribute;";
	$res = da_sql_query($link, $config, $sql);
	if ($res) {
		while ($row = da_sql_fetch_array($res, $config)) {
			$userAttr[$row['attribute']] = $row['value'];
		}
	}
}

// Format user attributes
$userAttr['Session-Timeout']   = ((isset($userAttr['Session-Timeout']))   ? formatTime($userAttr['Session-Timeout'])   : $l_unlimited);
$userAttr['Max-All-Session']   = ((isset($userAttr['Max-All-Session']))   ? formatTime($userAttr['Max-All-Session'])   : $l_unlimited);
$userAttr['Max-Daily-Session'] = ((isset($userAttr['Max-Daily-Session'])) ? formatTime($userAttr['Max-Daily-Session']) : $l_unlimited);
$userAttr['Expiration'] = ((isset($userAttr['Expiration'])) ? date('d - m - Y', strtotime($userAttr['Expiration'])) : $l_without);

// Generate tickets
$ticketsGenerator = new TicketsGenerator(['language' => $langue_imp]);

// Add user ticket
$ticketsGenerator->addTicket([
	'username'        => $username,
	'password'        => $password,
	'maxAllSession'   => $userAttr['Max-All-Session'],
	'sessionTimeout'  => $userAttr['Session-Timeout'],
	'maxDailySession' => $userAttr['Max-Daily-Session'],
	'expiration'      => $userAttr['Expiration']
]);

// Save the PDF and redirect user to it
$filename = 'ticket_' . $username . '.pdf';
// Remove accents
$filename = strtr(utf8_decode($filename), utf8_decode('ŠŒŽšœžŸ¥µÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜÝßàáâãäåæçèéêëìíîïðñòóôõöøùúûüýÿ'), 'SOZsozYYuAAAAAAACEEEEIIIIDNOOOOOOUUUUYsaaaaaaaceeeeiiiionoooooouuuuyy'); // TODO : manage all UTF-8 chars

$ret = $ticketsGenerator->saveAs($filename);
if (!$ret) {
	echo 'Error during tickets report generation';
	exit();
}

header('Location: ' . $filename);


/**
 * Format time in seconds to days/hours/minutes/secondes.
 *
 * @param int $time Time in seconds.
 *
 * @return string Formated time.
 */
function formatTime($time)
{
	$days     = floor($time / 86400); $rest = $time % 86400;
	$hours    = floor($rest /  3600); $rest = $rest %  3600;
	$minutes  = floor($rest /    60);
	$secondes = $rest % 60;

	$result = '';
	if ($days     != 0) $result .= $days.' J ';
	if ($hours    != 0) $result .= $hours.' H ';
	if ($minutes  != 0) $result .= $minutes.' m ';
	if ($secondes != 0) $result .= $secondes.' s ';

	return $result;
}
