<?php

// written by Alexandre BOUIJOUX

/*******************
 * READ CONF FILES *
 ******************/
define('CONF_FILE', '/usr/local/etc/alcasar.conf');

$conf_files = [CONF_FILE];

// Files reading test
foreach ($conf_files as $file) {
	if (!file_exists($file)) {
		exit("Requested file $file isn't present");
	}

	if (!is_readable($file)) {
		exit("Can't read the file $file");
	}
}

// Read ALCASAR CONF_FILE
$file_conf = fopen(CONF_FILE, 'r');
if (!$file_conf) {
	exit('Error opening the file '.CONF_FILE);
}
while (!feof($file_conf)) {
	$buffer = fgets($file_conf, 4096);
	if ((strpos($buffer, '=') !== false) && (substr($buffer, 0, 1) !== '#')) {
		$tmp = explode('=', $buffer, 2);
		$conf[trim($tmp[0])] = trim($tmp[1]);
	}
}

// Handle error messages
// Move errors messages from cookies to array.
$errors_msg = [];
$cookies_keys = [ "add_replica_error", "change_replicas_state_error", "add_ssh_key_error", "delete_ssh_key_error" ];
foreach ($cookies_keys as $key) {
	// Ignore if error didn't happened
	if (!array_key_exists($key, $_COOKIE)) {
		continue;
	}

	// Store message in errors messages array
	$errors_msg[$key] = $_COOKIE[$key];

	// Delete the cookie
	unset($_COOKIE[$key]);
	setcookie($key, false, 1);
}

// Choice of language
$Language = 'en';
if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
	$Langue	  = explode(',', $_SERVER['HTTP_ACCEPT_LANGUAGE']);
	$Language = strtolower(substr(chop($Langue[0]), 0, 2));
}
if ($Language === 'fr') {
	$l_action		= "Action";
	$l_add_to_list		= "Ajouter";
	$l_algorithm		= "Algorithme";
	$l_apply		= "Appliquer les changements";
	$l_bind_port		= "Port de liaison";
	$l_cant_read_pubkey	= "Impossible de lire la clé publique de 'root'.";
	$l_confirm_uninstall	= "Êtes-vous certain de vouloir désinstaller la fédération ?";
	$l_db_pwd		= "Mot de passe BDD";
	$l_db_user		= "Utilisateur BDD";
	$l_delete		= "Supprimer";
	$l_error_details	= "Détails des erreurs";
	$l_field		= "Champ";
	$l_go_network_conf_page	= "Allez sur la page de configuration réseau.";
	$l_host_name		= "Nom d'hôte";
	$l_hosts_settings	= "Paramètres de réplication des hôtes";
	$l_import_ssh_key	= "Importer une clé SSH";
	$l_install_repl		= "Installer la fédération";
	$l_ip_address		= "Adresse IP";
	$l_no_primary_connected = "Aucun primaire connecté";
	$l_no_ssh_key		= "Pas de clé SSH.";
	$l_not_connected	= "Non connecté";
	$l_pubkey_to_deploy	= "La clé doit être déployée sur les serveurs primaires.";
	$l_remote_access_mgmt	= "Gestion des accès distants";
	$l_remote_role		= "Rôle de l'hôte distant";
	$l_repl_io_running	= "État";
	$l_replication_install	= "Installer la Fédération";
	$l_replication_title	= "Fédération";
	$l_role_primary		= "Primaire";
	$l_role_secondary	= "Secondaire";
	$l_ssh_keys_for_primary	= "Liste des clés autorisées à se connecter à l'utilisateur local 'replication'.";
	$l_ssh_port		= "Port SSH";
	$l_ssh_user		= "Utilisateur SSH";
	$l_ssh_wan_enabled	= "Le SSH sur le WAN est activé.";
	$l_ssh_wan_must_be_on	= "Le SSH sur le WAN doit être activé.";
	$l_start		= "Démarrer";
	$l_stop			= "Arrêter";
	$l_uninstall_repl	= "Désinstaller la fédération";
	$l_value		= "Valeur";
	$l_want_server_as_prim	= "Vous voulez que le serveur soit primaire ?";
} else if ($Language === 'es') {
	$l_action		= "Action";
	$l_add_to_list		= "Ajouter";
	$l_algorithm		= "Algorithme";
	$l_apply		= "Appliquer les changements";
	$l_bind_port		= "Port de liaison";
	$l_cant_read_pubkey	= "Impossible de lire la clé publique de 'root'.";
	$l_confirm_uninstall	= "¿Estás seguro de que quieres desinstalar la federación?";
	$l_db_pwd		= "Mot de passe BDD";
	$l_db_user		= "Utilisateur BDD";
	$l_delete		= "Supprimer";
	$l_error_details	= "Détails des erreurs";
	$l_field		= "Champ";
	$l_go_network_conf_page	= "Allez sur la page de configuration réseau.";
	$l_host_name		= "Nom d'hôte";
	$l_hosts_settings	= "Paramètres de réplication des hôtes";
	$l_import_ssh_key	= "Importer une clé SSH";
	$l_install_repl		= "Creación de la federación";
	$l_ip_address		= "Adresse IP";
	$l_no_primary_connected = "Aucun primaire connecté";
	$l_no_ssh_key		= "Pas de clé SSH.";
	$l_not_connected	= "Non connecté";
	$l_pubkey_to_deploy	= "La clé doit être déployée sur les serveurs primaires.";
	$l_remote_access_mgmt	= "Gestion des accès distants";
	$l_remote_role		= "Rôle de l'hôte distant";
	$l_repl_io_running	= "État";
	$l_replication_install	= "Creación de la federación";
	$l_replication_title	= "Federación";
	$l_role_primary		= "Primaire";
	$l_role_secondary	= "Secondaire";
	$l_ssh_keys_for_primary	= "Liste des clés autorisées à se connecter à l'utilisateur local 'replication'.";
	$l_ssh_port		= "Port SSH";
	$l_ssh_user		= "Utilisateur SSH";
	$l_ssh_wan_enabled	= "Le SSH sur le WAN est activé.";
	$l_ssh_wan_must_be_on	= "Le SSH sur le WAN doit être activé.";
	$l_start		= "Démarrer";
	$l_stop			= "Arrêter";
	$l_uninstall_repl	= "Desinstalar la federación";
	$l_value		= "Valeur";
	$l_want_server_as_prim	= "Vous voulez que le serveur soit primaire ?";
} else {
	$l_action		= "Action";
	$l_add_to_list		= "Add";
	$l_algorithm		= "Algorithm";
	$l_apply		= "Apply changes";
	$l_bind_port		= "Bind port";
	$l_cant_read_pubkey	= "Can't read root's public key.";
	$l_confirm_uninstall	= "Are you sure you want to uninstall the federation?";
	$l_db_pwd		= "Database password";
	$l_db_user		= "Database user";
	$l_delete		= "Delete";
	$l_error_details	= "Error details";
	$l_field		= "Field";
	$l_go_network_conf_page	= "Go to network config page.";
	$l_host_name		= "Host name";
	$l_hosts_settings	= "Replicated hosts settings";
	$l_import_ssh_key	= "Import a SSH key";
	$l_install_repl		= "Setting up the federation";
	$l_ip_address		= "IP address";
	$l_no_primary_connected = "No primary connected";
	$l_no_ssh_key		= "No SSH key.";
	$l_not_connected	= "Not connected";
	$l_pubkey_to_deploy	= "The following public key has to be deployed on remote primary servers.";
	$l_remote_access_mgmt	= "Remote access management";
	$l_remote_role		= "Remote role";
	$l_repl_io_running	= "State";
	$l_replication_install	= "Setting up the federation";
	$l_replication_title	= "Federation";
	$l_role_primary		= "Primary";
	$l_role_secondary	= "Secondary";
	$l_ssh_keys_for_primary	= "List of keys allowed to connect to local 'replication' user.";
	$l_ssh_port		= "SSH port";
	$l_ssh_user		= "SSH user";
	$l_ssh_wan_enabled	= "SSH on WAN is enabled.";
	$l_ssh_wan_must_be_on	= "SSH on WAN must be enabled.";
	$l_start		= "Start";
	$l_stop			= "Stop";
	$l_uninstall_repl	= "Uninstall the federation";
	$l_value		= "Value";
	$l_want_server_as_prim	= "Want server to be a primary?";
}

$reg_ip      = '^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$';
$reg_ip_port = '^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])(\:([1-9]|[1-9][0-9]|[1-9][0-9]{2}|[1-9][0-9]{3}|[1-5][0-9]{4}|6[0-4][0-9]{3}|65[0-4][0-9]{2}|655[0-2][0-9]|6553[0-5]))$';
$reg_host    = '^[a-zA-Z0-9-_]+$';
$reg_ssh_key = "^(ssh-dss AAAAB3NzaC1kc3|ecdsa-sha2-nistp256 AAAAE2VjZHNhLXNoYTItbmlzdHAyNT|sk-ecdsa-sha2-nistp256@openssh.com AAAAInNrLWVjZHNhLXNoYTItbmlzdHAyNTZAb3BlbnNzaC5jb2|ssh-ed25519 AAAAC3NzaC1lZDI1NTE5|sk-ssh-ed25519@openssh.com AAAAGnNrLXNzaC1lZDI1NTE5QG9wZW5zc2guY29t|ssh-rsa AAAAB3NzaC1yc2)[0-9A-Za-z+/]+[=]{0,3}(\s.*)?$";
$reg_linux_user = "[a-z_][a-z0-9_-]*[$]?";
$reg_mariadb_user = "^[a-z]{1,32}$";

// Allow new SSH file size of 128kB;
$max_ssh_file_size = 131072;

$choice = $_POST['choice'] ?? "";
switch ($choice) {
	case 'install_replication':
		if (isset($conf['REPLICATION']) && $conf['REPLICATION'] == "on") {
			exit("Replication already installed.");}
		$stdout = [];
		exec('sudo /usr/local/bin/alcasar-replication-install.sh 2>&1', $stdout);
		header('Location: '.$_SERVER['PHP_SELF']);
		break;
	case 'uninstall_replication':
		if (!isset($conf['REPLICATION']) || $conf['REPLICATION'] == "off") {
			exit("Replication not installed.");}
		$stdout = [];
		exec('sudo /usr/local/bin/alcasar-replication-uninstall.sh 2>&1', $stdout);
		header('Location: '.$_SERVER['PHP_SELF']);
		break;
	case 'add_replica':
		$role = trim($_POST['role'] ?? "");
		$name = trim($_POST['name'] ?? "");
		$ip = trim($_POST['ip'] ?? "");
		$port = trim($_POST['port'] ?? "");
		$user = trim($_POST['user'] ?? "");
		$pwd = trim($_POST['pwd'] ?? "");
		$db_user = trim($_POST['db_user'] ?? "");
		$db_pwd = trim($_POST['db_pwd'] ?? "");
		$bind_port = trim($_POST['bind_port'] ?? "");
		$stdout = [];
		$return = 0;
		switch ($role) {
			case 'primary':
				exec("sudo /usr/local/bin/alcasar-replication-add.sh --to-primary"." --name=".escapeshellarg($name)." --address=".escapeshellarg($ip)." --port=".escapeshellarg($port)." --user=". escapeshellarg($user)." --db-user=".escapeshellarg($db_user)." --db-password=".escapeshellarg($db_pwd)." 2>&1", $stdout, $return);
				break;
			case 'secondary':
				exec("sudo /usr/local/bin/alcasar-replication-add.sh --to-secondary"." --name=".escapeshellarg($name)." --bind-port=".escapeshellarg($bind_port)." --db-user=".escapeshellarg($db_user)." --db-password=".escapeshellarg($db_pwd)." 2>&1", $stdout, $return);
				break;
			default:
				// Error
				exit();}
		// If script went wrong
		if ($return) {
			$key = $choice . "_error";
			// Concatenate stdout lines
			$value = implode(PHP_EOL, $stdout);
			// Save error message in cookies
			setcookie($key, $value);
		}
		header('Location: '.$_SERVER['PHP_SELF']);
		break;
	case 'change_replicas_state':
		$stdout = [];
		$return = 0;
		$key_prefix = "action_primary_";

		// Search for action_primary_<hostname> key
		foreach ($_POST as $key => $value) {
			if (!str_starts_with($key, $key_prefix)) {
				continue;}
			// Get the remote name
			$name = explode($key_prefix, $key)[1];
			switch ($value) {
				case 'start':
					exec("sudo /usr/local/bin/alcasar-replication-start.sh --name=".escapeshellarg($name)." 2>&1", $stdout, $return);
					break;
				case 'stop':
					exec("sudo /usr/local/bin/alcasar-replication-stop.sh --name=".escapeshellarg($name)." 2>&1", $stdout, $return);
					break;
				case 'delete':
					exec("sudo /usr/local/bin/alcasar-replication-delete.sh --name=".escapeshellarg($name)." 2>&1", $stdout, $return);
					break;
				default:
					break;
			}
		}
		// If script went wrong
		if ($return) {
			$key = $choice . "_error";
			// Concatenate stdout lines
			$value = implode(PHP_EOL, $stdout);
			// Save error message in cookies
			setcookie($key, $value);
		}
		header('Location: '.$_SERVER['PHP_SELF']);
		break;
	case 'add_ssh_key':
		$file = $_FILES['new_ssh_key_input'] ?? "";
		$stdout = [];
		$return = 0;
		// Stop if file doesn't exist
		if (empty($file)) {
			break;}
		// Check file size
		if ($file['size'] > $max_ssh_file_size) {
			break;}
		// Add new key(s) to authorized keys list
		$tmp_file = $file['tmp_name'];
		exec("sudo /usr/local/bin/alcasar-replication-ssh-keys-management.sh --add --file=$tmp_file 2>&1", $stdout, $return);
		// If script went wrong
		if ($return) {
			$key = $choice . "_error";
			// Concatenate stdout lines
			$value = implode(PHP_EOL, $stdout);
			// Save error message in cookies
			setcookie($key, $value);
		}
		header('Location: '.$_SERVER['PHP_SELF']);
		break;
	case 'delete_ssh_key':
		$stdout = [];
		$return = 0;
		$key_prefix = "action_ssh_key_";
		foreach ($_POST as $key => $value) {
			if (!str_starts_with($key, $key_prefix)) {
				continue;}
			$decoded_value = htmlspecialchars_decode($value);
			// Delete key
			exec("sudo /usr/local/bin/alcasar-replication-ssh-keys-management.sh --delete --regex=$decoded_value 2>&1", $stdout, $return);
			// If script went wrong
			if ($return) {
				$key = $choice . "_error";
				// Concatenate stdout lines
				$value = implode(PHP_EOL, $stdout);
				// Save error message in cookies
				setcookie($key, $value);
			}
		}
		header('Location: '.$_SERVER['PHP_SELF']);
		break;
	default:
		break;
}

?>
<!DOCTYPE HTML>
<html>
<head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
	<title><?= $l_replication_title ?></title>
	<link rel="stylesheet" href="/css/acc.css" type="text/css">
	<script src="/js/jquery.min.js"></script>
	<script src="/js/jquery.connections.js"></script>
	<script type="text/javascript">
		window.onload = main;
		function main() {
			show_fields_for_new_primary();
			set_required_on_common_fields();
			enable_apply_btn_if_selected_primary_action();
			enable_apply_btn_if_selected_ssh_key_action();
		}
		// Set 'required' attribute on fields needed by both primary and secondary
		function set_required_on_common_fields() {
			document.querySelectorAll(".role_primary.role_secondary").forEach((input) => {
				input.setAttribute("required", "");
			});
		}
		// Only enable fields needed for new primary remote
		function show_fields_for_new_primary() {
			// Toggle 'disabled' and 'required' attributes
			document.querySelectorAll("input[class='role_primary']").forEach((input) => {
				input.removeAttribute("disabled");
				input.setAttribute("required", "");
			});
			document.querySelectorAll("input[class='role_secondary']").forEach((input) => {
				input.setAttribute("disabled", "");
				input.removeAttribute("required");
			});
		}
		function show_fields_for_new_secondary() {
			// Toggle 'disabled' and 'required' attributes
			document.querySelectorAll("input[class='role_primary']").forEach((input) => {
				input.removeAttribute("required");
				input.setAttribute("disabled", "");
			});
			document.querySelectorAll("input[class='role_secondary']").forEach((input) => {
				input.setAttribute("required", "");
				input.removeAttribute("disabled");
			});
		}
		// Enable the remote's list Apply button if there are any pending actions
		function enable_apply_btn_if_selected_primary_action() {
			let btn = document.querySelector("#apply_changes_primary_btn");
			if (!btn) {
				return;}
			let change_to_apply = false;
			// Check for any pending change
			document.querySelectorAll(".primary_action_select").forEach((element) => {
				if (element.value != "") {
					btn.removeAttribute("disabled");
					change_to_apply = true;
				}
			});
			// Disable button if there are no pending changes
			if (!change_to_apply) {
				btn.setAttribute("disabled", "");
			}
		}
		// Enable the SSH keys's list Apply button if there are any pending actions
		function enable_apply_btn_if_selected_ssh_key_action() {
			let btn = document.querySelector("#apply_changes_ssh_key_btn");
			if (!btn) {
				return;
			}
			let change_to_apply = false;
			// Check for any pending change
			document.querySelectorAll(".ssh_key_action_input").forEach((element) => {
				if (element.checked) {
					btn.removeAttribute("disabled");
					change_to_apply = true;
				}
			});
			// Disable button if there are no pending changes
			if (!change_to_apply) {
				btn.setAttribute("disabled", "");
			}
		}
	</script>
</head>
<body>
<div id="ldoverlay" class="overlay">
	<div class="lds-spinner" id="spinner"><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div><div></div></div>
</div>
<?php if ($conf['REPLICATION'] == "on") { ?>
<div class="panel">
	<div class="panel-header"><?= $l_hosts_settings ?></div>
</div>
<div>
<table width="100%" cellspacing="0" cellpadding="5" border="1">
	<tr>
		<td width="50%" align="center">
			<?php $section = "change_replicas_state" ?>
			<form action="<?= htmlspecialchars($_SERVER['PHP_SELF']) ?>" method="POST">
			<input type="hidden" name="choice" value="<?= $section ?>">
			<table cellspacing="2" cellpadding="3" border="1" style="table-layout: auto; min-width: 10em;">
				<tr>
					<th><?= $l_ip_address ?></th>
					<th><?= $l_host_name ?></th>
					<th><?= $l_repl_io_running ?></th>
					<th><?= $l_bind_port ?></th>
					<th><?= $l_action ?></th>
				</tr>

				<?php
				$stdout = [];
				$return = 0;
				exec("sudo /usr/local/bin/alcasar-replication-list.sh --all 2>&1", $stdout, $return);

				// If script went wrong
				if ($return) {
					// Print error message
					$errors_msg[$section."_error"] = implode(PHP_EOL, $stdout);
				// Successfully fetched remotes stats
				} else {
					$connected_prims = [];
					$current_prim = "";
					// Parse stdout in keys-array
					foreach ($stdout as $row) {
						// Skip useless delimiter
						if (str_starts_with($row, '*')) {
							continue;
						}
						// Split key: value
						$exploded = explode(": ", $row);
						$key = $exploded[0];
						$value = $exploded[1] ?? "";
						// Create subarray when starting to display a new remote
						if (!strcmp($key, "Connection_name")) {
							$current_prim = $value;
							$connected_prims[$current_prim] = [];
						}
						// Put value in prim's subarray
						($connected_prims[$current_prim])[$key] = $value;
					}
					// Skip resetted replicas,
					// they will stay displayed still the next database restart.
					foreach ($connected_prims as $prim) {
						if (empty($prim["Relay_Log_File"])) {
							unset($connected_prims[$prim["Connection_name"]]);
						}
					}
					// List each connection
					foreach ($connected_prims as $prim) {
						?>
						<tr>
							<td><?php
								$master_host = $prim["Master_Host"];
								if ($master_host != "127.0.0.1") {
									echo "$master_host";
								} else {
									echo "$l_not_connected";
								}
							?></td>
							<td><?= $prim["Connection_name"] ?></td>
							<td><?= $prim["Slave_IO_Running"] ?></td>
							<td><?= $prim["Master_Port"] ?></td>
							<td>
								<select name="action_primary_<?= $prim["Connection_name"] ?>" class="primary_action_select" onchange="enable_apply_btn_if_selected_primary_action()">
									<option value=""></option>
									<?php
										// Actions available on all remotes
										$options = array(
											"start" => "$l_start",
											"stop" => "$l_stop",
											"delete" => "$l_delete"
										);
										// Remove some options depending on the current remote state
										switch ($prim["Slave_IO_Running"]) {
										case 'Yes':
										case 'Connecting':
											unset($options["start"]);
											unset($options["delete"]);
											break;
										case 'No':
											unset($options["stop"]);
											break;
										default:
											break;
										}

										// Print options
										foreach ($options as $key => $value) { ?>
											<option value="<?= $key ?>"><?= $value ?></option>
										<?php }
									 ?>
								</select>
							</td>
						</tr>
					<?php }
					// Show submit button if there are primary servers connected
					echo "<tr><td colspan=5 valign='middle' align='center'>";
					if (sizeof($connected_prims)) { ?>
						<input type="submit" id="apply_changes_primary_btn" value="<?= $l_apply ?>" onClick="document.getElementById('ldoverlay').style.display='block';">
					<?php } else { ?>
						<p><?= $l_no_primary_connected ?></p>
					<?php }
					echo "</td></tr>";
				} ?>
			</table>
			</form>
			<?php if (isset($errors_msg[$section."_error"])) { ?>
				<details open>
					<summary><?= $l_error_details ?></summary>
					<textarea readonly cols=50 rows=10><?= $errors_msg[$section."_error"] ?></textarea>
				</details>
			<?php } ?>
		</td>
		<td width="50%" valign="middle" align="center">
			<?php $section = "add_replica" ?>
			<form action="<?= htmlspecialchars($_SERVER['PHP_SELF']) ?>" method="POST">
			<input type="hidden" name="choice" value="<?= $section ?>">
				<table cellspacing="2" cellpadding="3" border="1">
					<tr>
						<th><?= $l_field ?></th>
						<th><?= $l_value ?></th>
					</tr>
					<tr>
						<td><?= $l_remote_role ?></td>
						<td>
							<fieldset>
								<div>
									<input type="radio" id="role_primary" name="role" value="primary" checked onClick="show_fields_for_new_primary()"/>
									<label for="role_primary"><?= $l_role_primary ?></label>

									<input type="radio" id="role_secondary" name="role" value="secondary" onClick="show_fields_for_new_secondary()"/>
									<label for="role_secondary"><?= $l_role_secondary ?></label>
								</div>
							</fieldset>
						</td>
					</tr>
					<tr>
						<td><label for="input_name"><?= $l_host_name ?></label></td>
						<td><input type="text" id="input_name" name="name" class="role_primary role_secondary" pattern="<?= $reg_host ?>"></td>
					</tr>
					<tr>
						<td><label for="input_ip"><?= $l_ip_address ?></label></td>
						<td><input type="text" id="input_ip" name="ip" class="role_primary" pattern="<?= $reg_ip ?>"></td>
					</tr>
					<tr>
						<td><label for="input_bind_port"><?= $l_bind_port ?></label></td>
						<td><input type="number" id="input_bind_port" name="bind_port" min="0" max="65535" class="role_secondary" pattern="<?= $reg_ip_port ?>"></td>
					</tr>
					<tr>
						<td><label for="input_port"><?= $l_ssh_port ?></label></td>
						<td><input type="number" id="input_port" name="port" min="0" max="65535" placeholder="22" class="role_primary" pattern="<?= $reg_ip_port ?>"></td>
					</tr>
					<tr>
						<td><label for="input_user"><?= $l_ssh_user ?></label></td>
						<td><input type="text" id="input_user" name="user" value="replication" disabled class="role_primary" pattern="<?= $reg_linux_user ?>"></td>
					</tr>
					<tr>
						<td><label for="input_db_user"><?= $l_db_user ?></label></td>
						<td><input type="text" id="input_db_user" name="db_user" value="replication" disabled class="role_primary role_secondary" pattern="<?= $reg_mariadb_user ?>"></td>
					</tr>
					<tr>
						<td><label for="input_db_pwd"><?= $l_db_pwd ?></label></td>
						<td><input type="password" id="input_db_pwd" name="db_pwd" class="role_primary role_secondary"></td>
					</tr>
					<tr>
						<td colspan=2 valign="middle" align="center">
							<input type="submit" class="button" value="<?= $l_add_to_list ?>" onClick="document.getElementById('ldoverlay').style.display='block';">
						</td>
					</tr>
				</table>
			</form>
			<?php if (isset($errors_msg[$section."_error"])) { ?>
				<details open>
					<summary><?= $l_error_details ?></summary>
					<textarea readonly cols=50 rows=10><?= htmlspecialchars($errors_msg[$section."_error"]) ?></textarea>
				</details>
			<?php } ?>
		</td>
	</tr>
</table>
</div>
<br>
<div class="panel">
	<div class="panel-header"><?= $l_remote_access_mgmt ?></div>
</div>
<div>
<table width="100%" cellspacing="0" cellpadding="5" border="1">
	<tr>
		<td width="50%" align="center">
			<p><?= $l_ssh_keys_for_primary ?></p>
			<?php $section = "delete_ssh_key" ?>
			<form action="<?= htmlspecialchars($_SERVER['PHP_SELF']) ?>" method="POST">
			<input type="hidden" name="choice" value="<?= $section ?>">
			<table cellspacing="2" cellpadding="3" border="1" style="table-layout: auto; min-width: 10em;">
				<tr>
					<th><?= $l_host_name ?></th>
					<th><?= $l_algorithm ?></th>
					<th><?= $l_delete ?></th>
				</tr>
				<?php
				$stdout = [];
				$return = 0;
				exec("sudo /usr/local/bin/alcasar-replication-ssh-keys-management.sh --list 2>&1", $stdout, $return);
				// If script went wrong
				if ($return) {
					// Print error message
					$errors_msg[$section."_error"] = implode(PHP_EOL, $stdout);
				// Successfully fetched remotes stats
				} else {
					// List each key
					foreach ($stdout as $line) {
						// Skip empty lines
						if (str_starts_with($line, ' ')) {
							continue;
						}
						// Split args
						$exploded = explode(' ', $line);
						$algo = $exploded[0] ?? "";
						$hostname = $exploded[2] ?? "";
						?>
						<tr>
							<td><?= $hostname ?></td>
							<td><?= $algo ?></td>
							<td>
								<input type="checkbox" name="action_ssh_key_<?= htmlspecialchars($hostname) ?>" value="<?= htmlspecialchars($hostname) ?>" class="ssh_key_action_input" onchange="enable_apply_btn_if_selected_ssh_key_action()">
							</td>
						</tr>
					<?php }

					// Show submit button if there are primary servers connected
					echo "<td colspan=3 valign='middle' align='center'>";
					if (sizeof($stdout)) { ?>
						<input type="submit" id="apply_changes_ssh_key_btn" value="<?= $l_apply ?>" onClick="document.getElementById('ldoverlay').style.display='block';">
					<?php } else { ?>
						<p><?= $l_no_ssh_key ?></p>
					<?php }
					echo "</td>";
				} ?>
			</table>
			</form>
			<?php if (isset($errors_msg[$section."_error"])) { ?>
				<details open>
					<summary><?= $l_error_details ?></summary>
					<textarea readonly cols=50 rows=10><?= $errors_msg[$section."_error"] ?></textarea>
				</details>
			<?php } ?>
		</td>
		<td width="25%" valign="middle" align="center">
			<?php $section = "add_ssh_key" ?>
			<form action="<?= htmlspecialchars($_SERVER['PHP_SELF']) ?>" method="POST" enctype="multipart/form-data">
			<input type="hidden" name="choice" value="<?= $section ?>">
				<input type="hidden" name="MAX_FILE_SIZE" value="<?= $max_ssh_file_size ?>" />
				<label for="new_ssh_key_input"><b><?= $l_import_ssh_key ?></b></label>
				<br>
				<input type="file" name="new_ssh_key_input" id="new_ssh_key_input" accept=".pub">
				<br>
				<input type="submit" class="button" value="<?= $l_add_to_list ?>" onClick="document.getElementById('ldoverlay').style.display='block';">
			</form>
			<?php if (isset($errors_msg[$section."_error"])) { ?>
				<details open>
					<summary><?= $l_error_details ?></summary>
					<textarea readonly cols=50 rows=10><?= $errors_msg[$section."_error"] ?></textarea>
				</details>
			<?php } ?>
		</td>
		<td width="25%" valign="middle" align="center">
				<label for="pubkey_stdout"><?= $l_pubkey_to_deploy ?></label>
				<br>
				<?php
				$stdout = [];
				$return = 0;
				exec("sudo /usr/local/bin/alcasar-replication-ssh-keys-management.sh --show-pubkey 2>&1", $stdout, $return);
				// If script went wrong
				if ($return != 0) {
					echo "<p>$l_cant_read_pubkey</p>";
				} else { ?>
					<input type="text" id="pubkey_stdout" readonly value="<?= implode(PHP_EOL, $stdout) ?>">
				<?php } ?>
		</td>
	</tr>
</table>
</div>
<br>
<?php } ?>
<div class="panel">
	<div class="panel-header"><?= $l_replication_title ?></div>
</div>
<table width="100%" cellspacing="0" cellpadding="5" border="1">
	<tr>
		<td width="50%" valign="middle" align="center">
			<?php if ($conf['REPLICATION'] == "on") { ?>
				<form action="<?= htmlspecialchars($_SERVER['PHP_SELF']) ?>" method="POST" onsubmit="return confirm('<?= $l_confirm_uninstall ?>');">
					<input type="hidden" name="choice" value="uninstall_replication">
					<input type="submit" value="<?= $l_uninstall_repl ?>" onClick="document.getElementById('ldoverlay').style.display='block';">
				</form>
			<?php } else { ?>
				<form action="<?= htmlspecialchars($_SERVER['PHP_SELF']) ?>" method="POST">
					<input type="hidden" name="choice" value="install_replication">
					<input type="submit" value="<?= $l_install_repl ?>" onClick="document.getElementById('ldoverlay').style.display='block';">
				</form>
			<?php } ?>
		</td>
		<?php if ($conf['REPLICATION'] == "on") { ?>
			<td width="50%" valign="middle" align="center">
				<?php if ($conf['SSH_WAN'] !== '0') { ?>
					<input type="checkbox" id="togglessh" checked disabled>
					<label for="togglessh"><?= $l_ssh_wan_enabled ?></label>
				<?php } else { ?>
				<p><?= $l_want_server_as_prim ?></p>
					<input type="checkbox" id="togglessh" disabled>
					<label for="togglessh"><b><?= $l_ssh_wan_must_be_on ?></b> <a href="/acc/admin/network.php"><?= $l_go_network_conf_page ?></a></label>
				<?php } ?>
			</td>
		<?php } ?>
	</tr>
</table>
</body>
</html>
