#!/bin/bash
# $Id: alcasar-sms.sh 3269 2025-04-21 21:57:13Z rexy $

# alcasar-sms.sh
# by Nicolas Aubry & Rexy
# This script is distributed under the Gnu General Public License (GPL)

# This script manages the 'gammu-smsd' service when a GSM adapter is detected
# Ce script gère le service 'gammu-smsd' quand un adaptateur GSM est détecté

CONF_FILE='/usr/local/etc/alcasar.conf'

#######	VARIABLES ########
nb_essais=3
time_account=1
time_ban=2
####### IDs DB ##########################
PASSWD_FILE="/root/ALCASAR-passwords.txt"
u_db=$(grep '^db_user='     $PASSWD_FILE | cut -d'=' -f2-)
p_db=$(grep '^db_password=' $PASSWD_FILE | cut -d'=' -f2-)
#########################################

rad="radcheck"
radgp="radusergroup"
radgpck="radgroupcheck"
radinf="userinfo"
sms_p="SMS_ban_perm"
sms_t="SMS_ban_temp"
inb="inbox"
SMS_c="SMS_country"
config="/etc/gammu_smsd_conf"
config2="/etc/gammurc"
logfile="/var/log/gammu-smsd/gammu-smsd.log"
script="/usr/local/bin/alcasar-sms.sh"
separator="########## START ##########"
end="%%%%%%%%%% STOP %%%%%%%%%%"

usage="Usage: alcasar-gammu.sh
Start Gammu-smsd   : --start
Stop Gammu-smsd    : --stop
Process on new sms : --new_sms"

nb_args=$#
args=$1

# Functions
function mode_huawei() {
	couple=$(lsusb | grep -i huawei | cut -d ' ' -f6)
	vendor=$(echo $couple | cut -d ':' -f1)
	product=$(echo $couple | cut -d ':' -f2)
	echo "******** Modeswitch *************" >> $logfile
	echo $vendor >> $logfile
	echo $product >> $logfile
	/usr/sbin/usb_modeswitch -I -H -v 0x$vendor -p 0x$product -V 0x$vendor -P 0x$product -W -n >> $logfile
} # end function mode_huawei

function start_gammu() {
	# Truncate phones table (informations signal/IMEI/battery/sent et reveived sms)
	mariadb --user=$u_db --password=$p_db --database=gammu -Bs -e 'TRUNCATE phones;'
	# Verify the sms group is created
	if [ $(mariadb --user=$u_db --password=$p_db --database=radius -Bs -e "SELECT COUNT(*) FROM $radgp WHERE username='sms' AND groupname='sms';") -eq 0 ]; then
		sql_add_gp="INSERT INTO $radgp (username,groupname) VALUES ('sms','sms'); INSERT INTO $radgpck (groupname,attribute,op,value) VALUES ('sms','Simultaneous-Use',':=',1);"
		mariadb --user=$u_db --password=$p_db --database=radius -Bs -e "$sql_add_gp"
	fi
	# Start gammu
	echo $separator >> $logfile
	/usr/bin/systemctl -q start gammu-smsd.service
	/usr/bin/systemctl -q enable gammu-smsd.service
} # end function start_gammu

function stop_gammu() {
	/usr/bin/systemctl -q stop gammu-smsd.service
	/usr/bin/systemctl -q disable gammu-smsd.service
	echo $end >> $logfile
} # end function stop_gammu

function unlock() {
	# Remove phone number in SMS_ban_perm table
		sql_remove_ban_perm="connect gammu; DELETE FROM $sms_p"
		mariadb --user=$u_db --password=$p_db -B -se "$sql_remove_ban_perm WHERE SenderNumber=$1;"
	# Add sms group
		sql_remove_gp="connect radius; DELETE FROM $radgp WHERE username='$1';"
		mariadb --user=$u_db --password=$p_db -B -se "$sql_remove_gp"
	# Remove account in Radcheck table
		sql_remove_compte="connect radius; DELETE FROM $rad WHERE username='$1';"
		mariadb --user=$u_db --password=$p_db -B -se "$sql_remove_compte"
} # end function unlock

function change_country() {
		sql_status_country="connect gammu; SELECT status FROM SMS_country WHERE name='$1'"
		stat=$(mariadb --user=$u_db --password=$p_db -B -se "$sql_status_country")
		if [ $stat -eq 0 ]
		then
			sql_change_country="connect gammu; UPDATE $SMS_c SET status=1 WHERE name='$1'"
			mariadb --user=$u_db --password=$p_db -B -se "$sql_change_country"
		else
			sql_change_country="connect gammu; UPDATE $SMS_c SET status=0 WHERE name='$1'"
			mariadb --user=$u_db --password=$p_db -B -se "$sql_change_country"
		fi
} # end change_country

function supp_acc_rad() {
	# Remove account in Radcheck table
		sql_del_compte="connect radius; DELETE FROM $rad WHERE username='$1';"
		mariadb --user=$u_db --password=$p_db -B -se "$sql_del_compte"
} # end function supp_acc_rad()

function add_acc_rad() {
	# Add accoubt in RadCheck table
		sql_add_pass="connect radius; INSERT INTO $rad (username,attribute,op,value) VALUES ('$1','Crypt-Password',':=','$2');"
		sql_add_expe="connect radius; INSERT INTO $rad (username,attribute,op,value) VALUES ('$1','Expiration',':=','$3');"
		mariadb --user=$u_db --password=$p_db -B -se "$sql_add_pass"
		mariadb --user=$u_db --password=$p_db -B -se "$sql_add_expe"
	# Add this account to sms group
		sql_add_gp="connect radius; INSERT INTO $radgp (username,groupname) VALUES ('$1','sms');"
		mariadb --user=$u_db --password=$p_db -B -se "$sql_add_gp"
} # end function add_acc_rad()

function supp_num_temp() {
	# Remove phone number in SMS_ban_temp table
		sql_remove_ban_temp="connect gammu; DELETE FROM $sms_t"
		mariadb --user=$u_db --password=$p_db -B -se "$sql_remove_ban_temp WHERE SenderNumber=$1;"
} # end function supp_num_temp()

function add_num_perm() {
	# Add phone number in SMS_ban_perm table
		sql_add_ban_perm="connect gammu; INSERT INTO $sms_p (SenderNumber,Perm,Expiration) VALUES ('$1',0,'$2');"
		mariadb --user=$u_db --password=$p_db -B -se "$sql_add_ban_perm"
} # end function add_num_perm()

function supp_num_perm() {
	# Remove phone number in SMS_ban_perm table
		sql_remove_ban_perm="connect gammu; DELETE FROM $sms_p"
		mariadb --user=$u_db --password=$p_db -B -se "$sql_remove_ban_perm WHERE SenderNumber=$1;"
} # end function add_num_perm()

function new_sms() {
	# Check Inbox table, manage Ban temp and perm, create account
		export salt='$5$passwd$'
		sql_select_inbox="connect gammu; SELECT ID, SenderNumber, TextDecoded FROM $inb;"
		sql_delete_inbox="connect gammu; DELETE FROM $inb"
		mariadb --user=$u_db --password=$p_db -B -se "$sql_select_inbox" | while read result;
		do
		# Retrieve the number of words (result)
			nb=$(echo $result | wc -w)
		# Retrive the ID
			id=$(echo $result | cut -d ' ' -f1)
			numero=$(echo $result | cut -d ' ' -f2)
			if [[ $numero =~ ^\+ ]]
			then
			# Check if country is blocked
				sql_select_countries="connect gammu; SELECT id FROM $SMS_c WHERE status=1"
				mariadb --user=$u_db --password=$p_db -B -se "$sql_select_countries" | while read result_c;
				do
					if [[ $numero =~ ^"$result_c" ]]
					then
						numero=$(echo $numero | cut -d '+' -f2)
				# Check if GSM number is nabbed
						sql_ban_perm="connect gammu; SELECT * FROM $sms_p WHERE SenderNumber=$numero"
						result_bp=$(mariadb --user=$u_db --password=$p_db -B -se "$sql_ban_perm")
						if test -z "$result_bp"
						then
						# Test the number of word (result)
							if [ $nb -eq 2 ] # if only 2 words : lack of password
							then
							# Add "1" in bans_temp table // NO PASSWORD
								sql_add_temp="connect gammu; INSERT INTO $sms_t(SenderNumber) VALUES ('$numero');"
								mariadb --user=$u_db --password=$p_db -B -se "$sql_add_temp"
							elif [ $nb -eq 3 ] # if 3 words (id + password + phone numbere)
							then
								export pass=$(echo $result | cut -d ' ' -f3)
								pass_salt=$(perl -e'print crypt($ARGV[0],$ARGV[1])' $pass $salt)
								export LC_TIME="en_US.UTF-8"
								expir=$(date '+%d %B %Y' -d "$time_account days")
								supp_acc_rad "$numero"
								add_acc_rad "$numero" "$pass_salt" "$expir"
								supp_num_temp "$numero"
								add_num_perm "$numero" "$expir"
							else # more then 3 words --> Add "1" in ban_temp table
								sql_add_temp="connect gammu; INSERT INTO $sms_t(SenderNumber) VALUES ('$numero');"
								mariadb --user=$u_db --password=$p_db -B -se "$sql_add_temp"
							fi
							# manage ban perm
							sql_select_temp="connect gammu; SELECT ID FROM $sms_t WHERE SenderNumber='$numero'"
							r_select_temp=$(mariadb --user=$u_db --password=$p_db -B -se "$sql_select_temp")
							nb_ban_t=$(echo $r_select_temp| wc -w)
							if [ $nb_ban_t -ge $nb_essais ]
							then
								supp_num_temp "$numero"
								export LC_TIME="en_US.UTF-8"
								expir_f=$(date '+%d %B %Y' -d "$time_ban days")
							# Add "1" in SMS_ban_perm table : flood
								sql_add_ban_perm="connect gammu; INSERT INTO $sms_p (SenderNumber,Perm,Expiration) VALUES ('$numero',1,'$expir_f');"
								mariadb --user=$u_db --password=$p_db -B -se "$sql_add_ban_perm"
							fi
						else
							date_expiration=$(echo $result_bp | cut -d ' ' -f2,3,4)
							perm=$(echo $result_bp | cut -d ' ' -f5)
							export LC_TIME="en_US.UTF-8"
							date_script=$(date '+%d %B %Y' -d "now")
							# convert in seconds in order to be able to compare
							d_exp=$(date --date "$date_expiration" +%s)
							d_scr=$(date --date "$date_script" +%s)
							if test $d_scr -ge $d_exp		# Si le ban à expiré
							then
							# Test the number of words (result)
								if [ $nb -eq 2 ]	# Si 2 mots : le mot de passe est manquant
								then
								# Add "1" in ban temp table
								sql_add_temp="connect gammu; INSERT INTO $sms_t(SenderNumber) VALUES ('$numero');"
								mariadb --user=$u_db --password=$p_db -B -se "$sql_add_temp"
								elif [ $nb -eq 3 ]	# Si 3 mots : id + mot de passe + numero
									then
									date_expiration=$(echo $result_bp | cut -d ' ' -f2,3,4)
									perm=$(echo $result_bp | cut -d ' ' -f5)
									date_script=$(date '+%d %B %Y' -d "now")
									# convert in seconds in order to be able to compare
									d_exp=$(date --date "$date_expiration" +%s)
									d_scr=$(date --date "$date_script" +%s)
									export pass=$(echo $result | cut -d ' ' -f3)
									pass_salt=$(perl -e'print crypt($ARGV[0],$ARGV[1])' $pass $salt)
									export LC_TIME="en_US.UTF-8"
									expir=$(date '+%d %B %Y' -d "$time_account days")
									supp_acc_rad "$numero"
									add_acc_rad "$numero" "$pass_salt" "$expir"
									supp_num_temp "$numero"
									supp_num_perm "$numero"
									add_num_perm "$numero" "$expir"
								else
								# number of words to big (> 3)
								# Add "1" in bans temp table
									sql_add_temp="connect gammu; INSERT INTO $sms_t(SenderNumber) VALUES ('$numero');"
									mariadb --user=$u_db --password=$p_db -B -se "$sql_add_temp"
									echo "Mot de passe incorrect, ajout du numero en ban temporaire"
								fi
							# manage bans_temp & ban_perm
								sql_select_temp="connect gammu; SELECT ID FROM $sms_t WHERE SenderNumber='$numero'"
								r_select_temp=$(mariadb --user=$u_db --password=$p_db -B -se "$sql_select_temp")
								nb_ban_t=$(echo $r_select_temp| wc -w)
								if [ $nb_ban_t -ge $nb_essais ]
								then
									supp_num_perm "$numero"
									supp_num_temp "$numero"
									export LC_TIME="en_US.UTF-8"
									expir_f=$(date '+%d %B %Y' -d "$time_ban days")
									# Add phne number in ban_perm : flood
									sql_add_ban_perm="connect gammu; INSERT INTO $sms_p (SenderNumber,Perm,Expiration) VALUES ('$numero',1,'$expir_f');"
									mariadb --user=$u_db --password=$p_db -B -se "$sql_add_ban_perm"
								fi
							else
									echo "Le ban de $numero est encore valide"
							fi
						break
						fi
					#else
					#echo "Pays bloqué"
					fi
				done
			else
				echo "Numero non autorisé (ex: 36665)"
			fi
			# On supprime la ligne d'ID=$id dans inbox
			mariadb --user=$u_db --password=$p_db -B -e "$sql_delete_inbox WHERE ID=$id;"
		done
} # end function new_sms


# CORE
case $args in
	-h | --help)
		echo "$usage"
		exit 0
		;;
	--start)
		failed="0"
		comports=`ls -l /dev/ttyUSB* 2>/dev/null | wc -l`
		if [ $comports == "0" ]
		then
			echo "No GSM modem found."
			failed="1"
		fi	
		if [ -z "$(grep '^SMS_NUM=' $CONF_FILE | cut -d'=' -f2-)" ]; then
			echo 'The phone number is not set.'
			failed="1"
		fi
		if [ $failed == "1" ]
		then
			sed -i "s/^SMS=.*/SMS=off/" $CONF_FILE
			exit 0
		fi
		gammu_pid=`/usr/bin/pidof gammu-smsd|wc -l`
		if [ $gammu_pid != "0" ]
		then
			echo "Gammu is already started"
		else
			start_gammu
			sleep 1
			is_active=`systemctl is-active gammu-smsd`
			if [ $is_active == "active" ]
			then
				sed -i "s/^SMS=.*/SMS=on/" $CONF_FILE
			else
				sed -i "s/^SMS=.*/SMS=off/" $CONF_FILE
			fi
		fi
		exit 0
		;;
	--stop)
		gammu_pid=`/usr/bin/pidof gammu-smsd|wc -l`
		if [ $gammu_pid != "0" ]
		then
			stop_gammu
		else
			echo "Gammu is already stopped"
		fi
		sed -i "s/^SMS=.*/SMS=off/" $CONF_FILE
		exit 0
		;;
	--pidof)
		/usr/bin/pidof gammu-smsd
		;;
	--last_nosim)
		# Récupère la dernière ligne où NOSIM est présent (error)
		cat $logfile | grep -n "NOSIM" | cut -d ':' -f1 | tail -n 1
		exit 0
		;;
	--last_start)
		# Récupère la dernière ligne où ########## est présent (séparateur)
		cat $logfile | grep -n "##########" | cut -d ':' -f1 | tail -n 1
		exit 0
		;;
	--last_stop)
		# Récupère la dernière ligne où %%%%%%%%%% est présent (séparateur)
		cat $logfile | grep -n "%%%%%%%%%%" | cut -d ':' -f1 | tail -n 1
		exit 0
		;;
	--last_writeerror)
		#Récupère la dernière ligne où DEVICEWRITEERROR est présent (error)
		cat $logfile | grep -n "DEVICEWRITEERROR" | cut -d ':' -f1 | tail -n 1
		exit 0
		;;
	--last_timeout)
		# Récupère la dernière ligne où TIMEOUT est présent (error)
		cat $logfile | grep -n "TIMEOUT" | cut -d ':' -f1 | tail -n 1
		exit 0
		;;
	--last_secu)
		# Récupère la dernière ligne où SECURITYERROR est présent (error)
		cat $logfile | grep -n "SECURITYERROR" | cut -d ':' -f1 | tail -n 1
		exit 0
		;;
	--last_puk)
		# Récupère la dernière ligne où PUK est présent (error)
		cat $logfile | grep -n "UNKNOWN" | cut -d ':' -f1 | tail -n 1
		exit 0
		;;
	#--log)
	#	# Récupère le nom du fichier de log
	#	cat $config | grep logfile | cut -d ' ' -f3
	#	exit 0
	#	;;
	--connect)
		# display the com port speed
		cat $config | grep connection | cut -d ' ' -f3
		exit 0
		;;
	--replace_port)
		# modify the com port
		echo $2
		sed -i "s?^port = .*?port = $2?g" $config
		sed -i "0,/^device =/ s?device =.*?device = $2?" $config2
		exit 0
		;;
	--replace_speed)
		# modufy the com port speed
		sed -i "s/^connection = at.*/connection = at$2/g" $config
		sed -i "0,/^connection =/ s/connection =.*/connection = $2/" $config2
		exit 0
		;;
	--pin)
		# Récupère le code PIN (file de conf)
		cat $config | grep PIN | cut -d ' ' -f3
		exit 0
		;;
	--replace_pin)
		# Edition du code PIN
		sed -i "s/^PIN =.*/PIN = $2/g" $config
		exit 0
		;;
	--try_ban)
		# Récupère le nombre d'essais avant le ban perm
		grep nb_essais= $script | head -n 1 | cut -d '=' -f2
		exit 0
		;;
	--replace_try_ban)
		# Edition le nombre d'essais avant le ban perm
		sed -i "s/^nb_essais=.*/nb_essais=$2/g" $script
		exit 0
		;;
	--time_account)
		# Récupère la durée en jours de la session créée
		grep time_account= $script | head -n 1 | cut -d '=' -f2
		exit 0
		;;
	--replace_time_account)
		# Edition de la durée de la session créée
		sed -i "s/^time_account=.*/time_account=$2/g" $script
		exit 0
		;;
	--time_perm)
		# Récupère la durée un jours d'un ban perm (après flood par exemple)
		grep time_ban= $script | head -n 1 | cut -d '=' -f2
		exit 0
		;;
	--replace_time_perm)
		# Edition de la durée d'un ban perm
		sed -i "s/^time_ban=.*/time_ban=$2/g" $script
		exit 0
		;;
	--unlock_num)
		# Appel de la fonction unlock : deban un numero $2
		unlock "$2"
		exit 0
		;;
	--change_country)
		# Permet de changer l'état de blocage d'un pays
		a=""
		for i in "$@"
		do
			a=$(echo "$a $i")
		done
		a=$(echo $a | cut -d ' ' -f2-$#)
		change_country "$a"
		exit
		;;
	--change_country_ena_all)
		# Active l'ensemble des pays
		sql_change_country="connect gammu; UPDATE $SMS_c SET status=1"
		mariadb --user=$u_db --password=$p_db -B -se "$sql_change_country"
		exit
		;;
	--change_country_dis_all)
		# Desactive l'ensemble des pays
		sql_change_country="connect gammu; UPDATE $SMS_c SET status=0"
		mariadb --user=$u_db --password=$p_db -B -se "$sql_change_country"
		exit
		;;
	--change_country_filter)
		# Change la valeur du filtrage (FR, UE, all, perso)
		sql_change_country="connect gammu; UPDATE $SMS_c SET id='$2' WHERE name='FILTRAGE'"
		mariadb --user=$u_db --password=$p_db -B -se "$sql_change_country"
		break
		;;
	--new_sms)
		# Appel de la fonction new_sms : filtrage du password, creation du compte et ban
		new_sms
		exit 0
		;;
	--imei_device)
		# Recuperation de l'imei du device
		sql_imei_phones="connect gammu; SELECT \`IMEI\` FROM phones;"
		mariadb --user=$u_db --password=$p_db -B -se "$sql_imei_phones"
		exit 0
		;;
	--signal_device)
		# Recuperation du signal du device
		sql_signal_phones="connect gammu; SELECT \`Signal\` FROM phones;"
		mariadb --user=$u_db --password=$p_db -B -se "$sql_signal_phones"
		exit 0
		;;
	--sms_received)
		# Recuperation du nombre de sms reçu. Depuis la dernière activation.
		sql_sms_received="connect gammu; SELECT \`Received\` FROM phones;"
		mariadb --user=$u_db --password=$p_db -B -se "$sql_sms_received"
		exit 0
		;;
	--numero_alcasar)
		# Récupère le numero de la clé 3g (téléphone)
		grep '^SMS_NUM=' $CONF_FILE | cut -d'=' -f2-
		exit 0
		;;
	--replace_numero_alcasar)
		# Edition du numero de la clé 3g (téléphone)
		sed -i "s/^SMS_NUM=.*/SMS_NUM=$2/" $CONF_FILE
		exit 0
		;;
	--mode)
		# Mode huawei
		mode_huawei
		exit 0
		;;
	*)
		# Default
		echo "$usage"
		exit 0
		;;
esac
exit 0
