#!/bin/bash

###########################################################################################
##				    ALCASAR MAIL SERVICE CONFIGURATION
##
##	Script by K@M3L & T3RRY (LaPlateforme.io), joss_p & Rexy
##  This script configure PostFix
##		0 : no email autoregistration
##		1 : PostFix is the SMTP server
##		2 : PostFix relay to an other SMTP server
##		3 : PostFix use an external email address (with Cyrus-SASL)
###########################################################################################

######################################################
##			Email configuration examples (mode = 3)
## common parameters : smtp_use_tls = yes, smtp_tls_security_level = encrypt, smtp_sasl_auth_enable = yes
## common rules : 'myhostname' parameter should be the domain name of the sasl_email account
########## smtp.free.fr:465 (expose mechanisms : PLAIN LOGIN CRAM-MD5 DIGEST-MD5)
## smtp_sasl_security_option = noanonymous, relayhost = [smtp.free.fr]:465, smtp_tls_wrappermode = yes
########## smtp.free.fr:587 (expose mechanismes
## smtp_sasl_security_option = noanonymous, relayhost = [smtp.free.fr]:587, smtp_tls_wrappermode = no, smtputf8_enable = no
########## smtp.orange.fr:465 (expose mechanisms : LOGIN PLAIN)
## smtp_sasl_security_option = noanonymous, relayhost = [smtp.orange.fr]:465, smtp_tls_wrappermode = yes, smtputf8_enable = no
########## smtp.sfr.fr:465 (expose mechanisms : LOGIN PLAIN)
## smtp_sasl_security_option = noanonymous, relayhost = [smtp.sfr.fr]:465, smtp_tls_wrappermode = yes
########## smtp.laposte.net:465 (expose mechanisms : LOGIN PLAIN)
## smtp_sasl_security_option = noanonymous, relayhost = [laposte.net]:465, smtp_tls_wrappermode = yes
########## smtp.bbox.net:465 (expose mechanisms : LOGIN PLAIN)
## smtp_sasl_security_option = noanonymous, relayhost = [laposte.net]:465, smtp_tls_wrappermode = yes
########## smtp.gmail.com:587 (expose mechanisms : LOGIN PLAIN XOAUTH2 PLAIN-CLIENTTOKEN OAUTHBEARER XOAUTH)
## smtp_sasl_security_option = noanonymous, relayhost = [gmail.com]:587, smtp_tls_wrappermode = no
## In this case (gmail) the password must be an "application password" created via the gmail account manager (security tab)

# ****** Paths *******
SED="/bin/sed -i"
CONF_FILE="/usr/local/etc/alcasar.conf"
POSTFIX_CONF_FILE="/etc/postfix/main.cf"
LOCAL_IPTABLE_FILE="/usr/local/etc/alcasar-iptables-local.sh"
SASLPATH="/etc/postfix/sasl"
smtpIP="0.0.0.0/0"
hostName=`grep ^HOSTNAME= $CONF_FILE|cut -d"=" -f2`
domainName=`grep ^DOMAIN= $CONF_FILE|cut -d"=" -f2`
usage="Usage: alcasar-mail_install.sh -h|-0|-1|-2|-3"

nb_args=$#
if [ $nb_args -eq 0 ]; then  # apply alcasar.conf
	mail=`grep ^MAIL= $CONF_FILE|cut -d"=" -f2`
	if [ "$mail" = "off" ]; then
		TYPE_MAIL=0
	else
		TYPE_MAIL=`grep ^MAIL_TYPE= $CONF_FILE|cut -d"=" -f2`
		smtpPort=`grep ^MAIL_SMTP_PORT= $CONF_FILE|cut -d"=" -f2`
		smtpIP=`grep ^MAIL_SMTP_IP= $CONF_FILE|cut -d"=" -f2`
		mailAddr=`grep ^MAIL_ADDR= $CONF_FILE|cut -d"=" -f2`
		[ -e ${SASLPATH}/sasl_passwd ] && mailMdp=`cat $SASLPATH/sasl_passwd|cut -d":" -f3`
		adminMail=`grep ^MAIL_ADMIN= $CONF_FILE|cut -d"=" -f2`
		whiteDomain=`grep ^MAIL_WHITEDOMAIN= $CONF_FILE|cut -d"=" -f2`
	fi
else # apply args
	if [ "$1" = "-h" ] || [ "$1" = "--h" ]; then
		echo $usage
		exit 0
	fi
	while getopts ":h:s:p:m:o:a:w:0123" option
	do
		case $option in
			0)
				TYPE_MAIL=0
			;;
			1)
				TYPE_MAIL=1
			;;
			2)
				TYPE_MAIL=2
			;;
			3)
				TYPE_MAIL=3
			;;
			p)
				smtpPort=$OPTARG
			;;
			s)
				smtpIP=$OPTARG
			;;
			m)
				mailAddr=$OPTARG
			;;
			o)
				mailMdp=$OPTARG
			;;
			a)
				adminMail=$OPTARG
			;;
			w)
				whiteDomain=$OPTARG
			;;
			:)
				echo "L'option $OPTARG requiert un argument"
				exit 1
			;;
			\?)
				echo "$OPTARG : option invalide"
				exit 1
			;;
		esac
	done
fi
if  [[ $TYPE_MAIL -eq 0 ]]; then # disable mail service
	$SED "s/^MAIL=.*/MAIL=off/" $CONF_FILE
	$SED "s/^MAIL_TYPE=.*/MAIL_TYPE=/" $CONF_FILE
	$SED "s/^MAIL_SMTP_IP=.*/MAIL_SMTP_IP=/" $CONF_FILE
	$SED "s/^MAIL_SMTP_PORT=.*/MAIL_SMTP_PORT=/" $CONF_FILE
	$SED "s/^MAIL_ADDR=.*/MAIL_ADDR=/" $CONF_FILE
	$SED "s/^MAIL_WHITEDOMAIN=.*/MAIL_WHITEDOMAIN=/" $CONF_FILE
	$SED "s/^MAIL_ADMIN=.*/MAIL_ADMIN=/" $CONF_FILE
	$SED "/^SMTP_IP=/ s/^/#/" $LOCAL_IPTABLE_FILE
	$SED "/^SMTP_PORT=/ s/^/#/" $LOCAL_IPTABLE_FILE
	$SED "s/^\$IPTABLES -A OUTPUT -p tcp --dport \$SMTP_PORT.*/#\$IPTABLES -A OUTPUT -p tcp --dport \$SMTP_PORT -d \$SMTP_IP -m conntrack --ctstate NEW,ESTABLISHED -j ACCEPT/" $LOCAL_IPTABLE_FILE
	$SED "s/^\$IPTABLES -A INPUT  -p tcp --sport \$SMTP_PORT.*/#\$IPTABLES -A INPUT  -p tcp --sport \$SMTP_PORT -s \$SMTP_IP -m conntrack --ctstate ESTABLISHED     -j ACCEPT/" $LOCAL_IPTABLE_FILE
	$SED "s/^relayhost =.*/relayhost =/" $POSTFIX_CONF_FILE
	$SED "s/^smtp_tls_security_level =.*/smtp_tls_security_level = may/g" $POSTFIX_CONF_FILE
	$SED "s/^smtp_tls_wrappermode =.*/smtp_tls_wrappermode = no/g" $POSTFIX_CONF_FILE
	$SED "s/^myhostname =.*/myhostname = $hostName.$domainName/g" $POSTFIX_CONF_FILE
	[ -e ${SASLPATH}/sasl_passwd ] && rm -f ${SASLPATH}/*
elif [[ $TYPE_MAIL -eq 1 ]]; then # Enable mail service (act as smtp server)
	$SED "s/^MAIL=.*/MAIL=on/" $CONF_FILE
	$SED "s/^MAIL_TYPE=.*/MAIL_TYPE=1/" $CONF_FILE
	$SED "s/^MAIL_SMTP_IP=.*/MAIL_SMTP_IP=/" $CONF_FILE
	$SED "s/^MAIL_SMTP_PORT=.*/MAIL_SMTP_PORT=$smtpPort/" $CONF_FILE
	$SED "s/^MAIL_ADDR=.*/MAIL_ADDR=/" $CONF_FILE
	$SED "s/^MAIL_WHITEDOMAIN=.*/MAIL_WHITEDOMAIN=$whiteDomain/" $CONF_FILE
	$SED "s/^MAIL_ADMIN=.*/MAIL_ADMIN=$adminMail/" $CONF_FILE
	$SED "/^SMTP_IP=/ s/^/#/" $LOCAL_IPTABLE_FILE
	$SED "s/^SMTP_PORT=.*/SMTP_PORT=$smtpPort/" $LOCAL_IPTABLE_FILE
	$SED "s/^\$IPTABLES -A OUTPUT -p tcp --dport \$SMTP_PORT.*/\$IPTABLES -A OUTPUT -p tcp --dport \$SMTP_PORT -m conntrack --ctstate NEW,ESTABLISHED -j ACCEPT/" $LOCAL_IPTABLE_FILE
	$SED "s/^\$IPTABLES -A INPUT  -p tcp --sport \$SMTP_PORT.*/\$IPTABLES -A INPUT  -p tcp --sport \$SMTP_PORT -m conntrack --ctstate ESTABLISHED     -j ACCEPT/" $LOCAL_IPTABLE_FILE
	$SED "s/^#SMTP_PORT=.*/SMTP_PORT=$smtpPort/" $LOCAL_IPTABLE_FILE
	$SED "s/^#\$IPTABLES -A OUTPUT -p tcp --dport \$SMTP_PORT.*/\$IPTABLES -A OUTPUT -p tcp --dport \$SMTP_PORT -m conntrack --ctstate NEW,ESTABLISHED -j ACCEPT/" $LOCAL_IPTABLE_FILE
	$SED "s/^#\$IPTABLES -A INPUT  -p tcp --sport \$SMTP_PORT.*/\$IPTABLES -A INPUT  -p tcp --sport \$SMTP_PORT -m conntrack --ctstate ESTABLISHED     -j ACCEPT/" $LOCAL_IPTABLE_FILE
	$SED "s/^relayhost =.*/relayhost =/" $POSTFIX_CONF_FILE
	$SED "s/^smtp_tls_security_level =.*/smtp_tls_security_level = may/g" $POSTFIX_CONF_FILE
	$SED "s/^smtp_tls_wrappermode =.*/smtp_tls_wrappermode = no/g" $POSTFIX_CONF_FILE
	$SED "s/^myhostname =.*/myhostname = $hostName.$domainName/g" $POSTFIX_CONF_FILE
	[ -e ${SASLPATH}/sasl_passwd ] && rm -f ${SASLPATH}/*
elif [[ $TYPE_MAIL -eq 2 ]]; then # Enable mail service (relaying to an extern mail server)
	$SED "s/^MAIL=.*/MAIL=on/" $CONF_FILE
	$SED "s/^MAIL_TYPE=.*/MAIL_TYPE=2/" $CONF_FILE
	$SED "s/^MAIL_SMTP_IP=.*/MAIL_SMTP_IP=$smtpIP/" $CONF_FILE
	$SED "s/^MAIL_SMTP_PORT=.*/MAIL_SMTP_PORT=$smtpPort/" $CONF_FILE
	$SED "s/^MAIL_ADDR=.*/MAIL_ADDR=/" $CONF_FILE
	$SED "s/^MAIL_WHITEDOMAIN=.*/MAIL_WHITEDOMAIN=$whiteDomain/" $CONF_FILE
	$SED "s/^MAIL_ADMIN=.*/MAIL_ADMIN=$adminMail/" $CONF_FILE
	$SED "s/^SMTP_IP=.*/SMTP_IP=$smtpIP/" $LOCAL_IPTABLE_FILE
	$SED "s/^SMTP_PORT=.*/SMTP_PORT=$smtpPort/" $LOCAL_IPTABLE_FILE
	$SED "s/^\$IPTABLES -A OUTPUT -p tcp --dport \$SMTP_PORT.*/\$IPTABLES -A OUTPUT -p tcp --dport \$SMTP_PORT -d \$SMTP_IP -m conntrack --ctstate NEW,ESTABLISHED -j ACCEPT/" $LOCAL_IPTABLE_FILE
	$SED "s/^\$IPTABLES -A INPUT  -p tcp --sport \$SMTP_PORT.*/\$IPTABLES -A INPUT  -p tcp --sport \$SMTP_PORT -s \$SMTP_IP -m conntrack --ctstate ESTABLISHED     -j ACCEPT/" $LOCAL_IPTABLE_FILE
	$SED "s/^#SMTP_IP=.*/SMTP_IP=$smtpIP/" $LOCAL_IPTABLE_FILE
	$SED "s/^#SMTP_PORT=.*/SMTP_PORT=$smtpPort/" $LOCAL_IPTABLE_FILE
	$SED "s/^#\$IPTABLES -A OUTPUT -p tcp --dport \$SMTP_PORT.*/\$IPTABLES -A OUTPUT -p tcp --dport \$SMTP_PORT -d \$SMTP_IP -m conntrack --ctstate NEW,ESTABLISHED -j ACCEPT/" $LOCAL_IPTABLE_FILE
	$SED "s/^#\$IPTABLES -A INPUT  -p tcp --sport \$SMTP_PORT.*/\$IPTABLES -A INPUT  -p tcp --sport \$SMTP_PORT -s \$SMTP_IP -m conntrack --ctstate ESTABLISHED     -j ACCEPT/" $LOCAL_IPTABLE_FILE
	$SED "s/^relayhost =.*/relayhost = [$smtpIP]:$smtpPort/g" $POSTFIX_CONF_FILE
	$SED "s/^smtp_tls_security_level =.*/smtp_tls_security_level = may/g" $POSTFIX_CONF_FILE
	$SED "s/^smtp_tls_wrappermode =.*/smtp_tls_wrappermode = no/g" $POSTFIX_CONF_FILE
	$SED "s/^myhostname =.*/myhostname = $hostName.$domainName/g" $POSTFIX_CONF_FILE
	[ -e ${SASLPATH}/sasl_passwd ] && rm -f ${SASLPATH}/*
elif [[ $TYPE_MAIL -eq 3 ]]; then # Enable mail service (using an email address)
	$SED "s/^MAIL=.*/MAIL=on/" $CONF_FILE
	$SED "s/^MAIL_TYPE=.*/MAIL_TYPE=3/" $CONF_FILE
	$SED "s/^MAIL_SMTP_IP=.*/MAIL_SMTP_IP=$smtpIP/" $CONF_FILE
	$SED "s/^MAIL_SMTP_PORT=.*/MAIL_SMTP_PORT=$smtpPort/" $CONF_FILE
	$SED "s/^MAIL_ADDR=.*/MAIL_ADDR=$mailAddr/" $CONF_FILE
	$SED "s/^MAIL_WHITEDOMAIN=.*/MAIL_WHITEDOMAIN=$whiteDomain/" $CONF_FILE
	$SED "s/^MAIL_ADMIN=.*/MAIL_ADMIN=$adminMail/" $CONF_FILE
	$SED "s/^SMTP_IP=.*/SMTP_IP=$smtpIP/" $LOCAL_IPTABLE_FILE
	$SED "s/^SMTP_PORT=.*/SMTP_PORT=$smtpPort/" $LOCAL_IPTABLE_FILE
	$SED "s/^\$IPTABLES -A OUTPUT -p tcp --dport \$SMTP_PORT.*/\$IPTABLES -A OUTPUT -p tcp --dport \$SMTP_PORT -m conntrack --ctstate NEW,ESTABLISHED -j ACCEPT/" $LOCAL_IPTABLE_FILE
	$SED "s/^\$IPTABLES -A INPUT  -p tcp --sport \$SMTP_PORT.*/\$IPTABLES -A INPUT  -p tcp --sport \$SMTP_PORT -m conntrack --ctstate ESTABLISHED     -j ACCEPT/" $LOCAL_IPTABLE_FILE
	$SED "s/^#SMTP_IP=.*/SMTP_IP=$smtpIP/" $LOCAL_IPTABLE_FILE
	$SED "s/^#SMTP_PORT=.*/SMTP_PORT=$smtpPort/" $LOCAL_IPTABLE_FILE
	$SED "s/^#\$IPTABLES -A OUTPUT -p tcp --dport \$SMTP_PORT.*/\$IPTABLES -A OUTPUT -p tcp --dport \$SMTP_PORT -m conntrack --ctstate NEW,ESTABLISHED -j ACCEPT/" $LOCAL_IPTABLE_FILE
	$SED "s/^#\$IPTABLES -A INPUT  -p tcp --sport \$SMTP_PORT.*/\$IPTABLES -A INPUT  -p tcp --sport \$SMTP_PORT -m conntrack --ctstate ESTABLISHED     -j ACCEPT/" $LOCAL_IPTABLE_FILE
	$SED "s/^relayhost =.*/relayhost = [$smtpIP]:$smtpPort/g" $POSTFIX_CONF_FILE
	$SED "s/^smtp_tls_security_level =.*/smtp_tls_security_level = encrypt/g" $POSTFIX_CONF_FILE
	if [ "$smtpPort" = "465" ]; then # wrappermode is madatory only if port = 465
		$SED "s/^smtp_tls_wrappermode =.*/smtp_tls_wrappermode = yes/g" $POSTFIX_CONF_FILE
	else
		$SED "s/^smtp_tls_wrappermode =.*/smtp_tls_wrappermode = no/g" $POSTFIX_CONF_FILE
	fi
	$SED "s/^myhostname =.*/myhostname = alcasar.net/g" $POSTFIX_CONF_FILE # use the alcasar domain name to avoid extern smtp servers reject
	[ -d ${SASLPATH} ] || mkdir ${SASLPATH}
	echo "[${smtpIP}]:${smtpPort} ${mailAddr}:${mailMdp}" > ${SASLPATH}/sasl_passwd
	postmap ${SASLPATH}/sasl_passwd
	chmod -R 644 ${SASLPATH}
	chown root:root ${SASLPATH}/sasl_passwd*
	chmod 0600 ${SASLPATH}/sasl_passwd*
else
	echo "Erreur ! Aucun type de messagerie sélectionné !"
	exit 0
fi
if [ "$PARENT_SCRIPT" != "alcasar.sh" ]; then  # don't launch on install stage
	/usr/local/bin/alcasar-iptables.sh
	systemctl restart postfix.service
fi
exit 0
