#!/bin/sh
#
# $Id: alcasar-iptables-local.sh 3283 2025-05-18 21:06:00Z rexy $
#
# Custom rules for ALCASAR firewall
#
# Examples:
# 	- Local MAC addresses filtering (MAC are in '/usr/local/etc/alcasar-iptables-local-mac-filtered'. Format : aa:09:23:2f:4d:ee)
#	- allow ICMP from an Internet IP address (Admin_from) to EXTIF
#	- Deny access to protected networks from internal LAN
#	- allow SMTP from ALCASAR to an other server
#	- Allow managers to access ACC from the external network
#	- Ports Address Translation (PAT) from Internet (one & multiple)
# This script inherit of alcasar-iptables.sh variables : $INTIF, $EXTIF, $IPTABLES, etc
# !!Beware, run the script "alcasar-iptables.sh" after changing this file. 

# Local MAC addresses filtering (MAC are in '/usr/local/etc/alcasar-iptables-local-mac-filtered'. Format : aa:09:23:2f:4d:ee)
if [ -s /usr/local/etc/alcasar-iptables-local-mac-filtered ]; then
	while read mac_line
	do
		ip_on=`echo $mac_line|cut -b1`
		if [ $ip_on != "#" ]
		then
			mac_filtered=`echo $mac_line|cut -d" " -f1`
			echo "MAC filtered = $mac_filtered"
			$IPTABLES -A FORWARD -i $INTIF        -m mac --mac-source $mac_filtered -j NFLOG --nflog-group 1 --nflog-prefix "$mac_filtered -- Filt_DROP"
			$IPTABLES -A FORWARD -i $INTIF -p tcp -m mac --mac-source $mac_filtered -j DROP
			$IPTABLES -A FORWARD -i $INTIF -p udp -m mac --mac-source $mac_filtered -j DROP
			$IPTABLES -A FORWARD -i $INTIF        -m mac --mac-source $mac_filtered -j DROP
		fi
	done < /usr/local/etc/alcasar-iptables-local-mac-filtered
fi

# On autorise le ping (echo & request) (ICMP N°0 & 8) en provenance d'Internet vers ALCASAR
# Allow ping (echo & request) (ICMP N°0 & 8) from Internet
#$IPTABLES -A INPUT  -i $EXTIF -p icmp --icmp-type 8 -j ACCEPT
#$IPTABLES -A OUTPUT -o $EXTIF -p icmp --icmp-type 0 -j ACCEPT

# On interdit aux utilisateurs l'accés à d'autres réseaux privés
# Deny access of users to other private networks
#protectedNetworks='10.0.0.0/8,172.16.0.0/12,192.168.0.0/16' # (RFC 1918)
#[ -n "$TUNIF" ] && consultationIF=$TUNIF || consultationIF=$INTIF
#$IPTABLES -A FORWARD -i $consultationIF -d $protectedNetworks -j DROP
#$IPTABLES -A FORWARD -o $consultationIF -s $protectedNetworks -j DROP

# On autorise ALCASAR à contacter un serveur MAIL externe (envoie de rapports, alertes, inscription d'utilisateurs, etc.)
# Allow ALCASAR to connect to a mail server (send reports, alerts, users registration, etc.)
#SMTP_IP='192.168.111.5'
#SMTP_PORT=25
#$IPTABLES -A OUTPUT -p tcp --dport $SMTP_PORT -d $SMTP_IP -m conntrack --ctstate NEW,ESTABLISHED -j ACCEPT
#$IPTABLES -A INPUT  -p tcp --sport $SMTP_PORT -s $SMTP_IP -m conntrack --ctstate ESTABLISHED     -j ACCEPT

# On autorise des @IP (managerIPs) à accéder à l'ACC depuis la carte extérieure (Internet ou le LAN entre ALCASAR et la BOX)
# Allow @IP (managerIPs) to access ACC from the external NICk (Internet or LAN between ALCASAR and the broadband router)
#managerIPs='192.168.0.10,192.168.0.15'
#externalPort='34443'
#$IPTABLES -t mangle -A PREROUTING -i $EXTIF -s $managerIPs -p tcp -d $PUBLIC_IP --dport $externalPort -j MARK --set-mark 100
#$IPTABLES -t nat    -A PREROUTING -i $EXTIF -s $managerIPs -p tcp -d $PUBLIC_IP --dport $externalPort -j DNAT --to $PRIVATE_IP:443
#$IPTABLES           -A INPUT      -i $EXTIF -s $managerIPs -p tcp --dport 443 -m mark --mark 100 -j ACCEPT

# On autorise l'accès depuis Internet (ex: port 11222) vers un equipement du LAN (ex: port 22). L'équipement sur le LAN doit être en IP fixe
# Access is allowed from Internet (ie: port 11222) to a LAN equipment (ie: port 22). The equipment must be in static IP
#$IPTABLES -A PREROUTING -i $EXTIF -t nat -p tcp -d $PUBLIC_IP --dport 11222 -j DNAT --to 192.168.182.10:22
#$IPTABLES -A PREROUTING -i $EXTIF -t nat -p udp -d $PUBLIC_IP --dport 11222 -j DNAT --to 192.168.182.10:22
#$IPTABLES -A FORWARD -p tcp -d 192.168.182.10 --dport 22 -j ACCEPT
#$IPTABLES -A FORWARD -p udp -d 192.168.182.10 --dport 22 -j ACCEPT

# On autorise l'accès depuis Internet (en multiports) vers un équipement du LAN (qui doit être en IP fixe)
# Access is allowed from Internet (multiports) to a LAN equipment (which must be in static IP)
#ext_ports=11223:11323; int_ports=12000:12100
#to_ip=192.168.182.7
#int_ports_dnat=`echo $int_ports|tr : -`
#ext_ports_dnat=`echo $ext_ports|tr : -`
#first_ext_port=`echo $ext_ports|cut -d":" -f1`
#$IPTABLES -A PREROUTING -i $EXTIF -t nat -p tcp -d $PUBLIC_IP --dport $ext_ports -j DNAT --to $to_ip:$int_ports_dnat/$first_ext_port
#$IPTABLES -A FORWARD -i $EXTIF -p tcp -d $to_ip -m multiport --dports $int_ports -j ACCEPT
#$IPTABLES -A PREROUTING -i $EXTIF -t nat -p udp -d $PUBLIC_IP --dport $ext_ports -j DNAT --to $to_ip:$int_ports_dnat/$first_ext_port
#$IPTABLES -A FORWARD -i $EXTIF -p udp -d $to_ip -m multiport --dports $int_ports -j ACCEPT

