#!/usr/bin/sh

DEVICE=$1

ifconfig $DEVICE 0.0.0.0 2>/dev/null || {
    echo "$0 <subscriber-lan-device>"
    echo "create a vlan interface with:"
    echo "  vconfig add <interface> <vlan-id>"
    exit
}

[ -d  /etc/chilli/$DEVICE ] || mkdir /etc/chilli/$DEVICE

cat > /etc/chilli/$DEVICE/chilli.conf <<EOF
# Generated by $0
include /etc/chilli/$DEVICE/main.conf
include /etc/chilli/$DEVICE/hs.conf
include /etc/chilli/$DEVICE/local.conf

ipup=/etc/chilli/up.sh
ipdown=/etc/chilli/down.sh
EOF

cat /etc/chilli/config | \
    grep -v HS_LANIF > /etc/chilli/$DEVICE/config